/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.TopologyUUID;
import org.jgroups.util.Util;

public final class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    private final TopologyUUID topologyAddress;

    public JGroupsTopologyAwareAddress(TopologyUUID address) {
        super((Address)address);
        this.topologyAddress = address;
    }

    @Override
    public String getSiteId() {
        return this.topologyAddress.getSiteId();
    }

    @Override
    public String getRackId() {
        return this.topologyAddress.getRackId();
    }

    @Override
    public String getMachineId() {
        return this.topologyAddress.getMachineId();
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        return this.getSiteId() == null ? addr.getSiteId() == null : this.getSiteId().equals(addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr)) {
            return false;
        }
        return this.getRackId() == null ? addr.getRackId() == null : this.getRackId().equals(addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (!this.isSameRack(addr)) {
            return false;
        }
        return this.getMachineId() == null ? addr.getMachineId() == null : this.getMachineId().equals(addr.getMachineId());
    }

    public static final class Externalizer
    implements AdvancedExternalizer<JGroupsTopologyAwareAddress> {
        @Override
        public void writeObject(ObjectOutput output, JGroupsTopologyAwareAddress address) throws IOException {
            try {
                Util.writeAddress((Address)address.address, (DataOutput)output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public JGroupsTopologyAwareAddress readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                TopologyUUID jgroupsAddress = (TopologyUUID)Util.readAddress((DataInput)unmarshaller);
                return new JGroupsTopologyAwareAddress(jgroupsAddress);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public Set<Class<? extends JGroupsTopologyAwareAddress>> getTypeClasses() {
            return Collections.singleton(JGroupsTopologyAwareAddress.class);
        }

        @Override
        public Integer getId() {
            return 60;
        }
    }
}

