/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.SubCache;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.util.Iterator;
import java.util.List;

final class Cache {
    public final Source source;
    private final SubCache allTagTypesSubCache;
    private final SubCache[] subCaches;

    public Cache(Source source) {
        this.source = source;
        this.allTagTypesSubCache = new SubCache(this, null);
        TagType[] separatelyCachedTagTypes = Cache.getSeparatelyCachedTagTypes();
        this.subCaches = new SubCache[separatelyCachedTagTypes.length + 1];
        this.subCaches[0] = this.allTagTypesSubCache;
        for (int i = 0; i < separatelyCachedTagTypes.length; ++i) {
            this.subCaches[i + 1] = new SubCache(this, separatelyCachedTagTypes[i]);
        }
    }

    public void clear() {
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].clear();
        }
    }

    public Tag getTagAt(int pos) {
        return this.source.useAllTypesCache ? this.allTagTypesSubCache.getTagAt(pos) : Tag.getTagAtUncached(this.source, pos);
    }

    public Tag findPreviousOrNextTag(int pos, boolean previous) {
        return this.allTagTypesSubCache.findPreviousOrNextTag(pos, previous);
    }

    public Tag findPreviousOrNextTag(int pos, TagType tagType, boolean previous) {
        int i;
        int n = i = this.source.useAllTypesCache ? 0 : 1;
        while (i < this.subCaches.length) {
            if (tagType == this.subCaches[i].tagType) {
                return this.subCaches[i].findPreviousOrNextTag(pos, previous);
            }
            ++i;
        }
        return Tag.findPreviousOrNextTagUncached(this.source, pos, tagType, previous, -1);
    }

    public Tag addTagAt(int pos) {
        Tag tag = Tag.getTagAtUncached(this.source, pos);
        this.allTagTypesSubCache.addTagAt(pos, tag);
        if (tag == null) {
            return tag;
        }
        TagType tagType = tag.getTagType();
        for (int i = 1; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            this.subCaches[i].addTagAt(pos, tag);
            return tag;
        }
        return tag;
    }

    public int getTagCount() {
        return this.allTagTypesSubCache.size() - 2;
    }

    public Iterator getTagIterator() {
        return this.allTagTypesSubCache.getTagIterator();
    }

    public void loadAllTags(List tags, Tag[] allRegisteredTags, StartTag[] allRegisteredStartTags) {
        int tagCount = tags.size();
        this.allTagTypesSubCache.bulkLoad_Init(tagCount);
        int registeredTagIndex = 0;
        int registeredStartTagIndex = 0;
        block0: for (int i = 0; i < tagCount; ++i) {
            Tag tag = (Tag)tags.get(i);
            if (!tag.isUnregistered()) {
                allRegisteredTags[registeredTagIndex++] = tag;
                if (tag instanceof StartTag) {
                    allRegisteredStartTags[registeredStartTagIndex++] = (StartTag)tag;
                }
            }
            this.allTagTypesSubCache.bulkLoad_Set(i, tag);
            for (int x = 1; x < this.subCaches.length; ++x) {
                if (tag.getTagType() != this.subCaches[x].tagType) continue;
                this.subCaches[x].bulkLoad_AddToTypeSpecificCache(tag);
                continue block0;
            }
        }
        for (int x = 1; x < this.subCaches.length; ++x) {
            this.subCaches[x].bulkLoad_FinaliseTypeSpecificCache();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].appendTo(sb);
        }
        return sb.toString();
    }

    protected int getSourceLength() {
        return this.source.end;
    }

    private static TagType[] getSeparatelyCachedTagTypes() {
        return TagType.getTagTypesIgnoringEnclosedMarkup();
    }
}

