/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;

public class EndTagTypeGenericImplementation
extends EndTagType {
    private final String staticString;

    protected EndTagTypeGenericImplementation(String description, String startDelimiter, String closingDelimiter, boolean isServerTag, boolean isStatic) {
        super(description, startDelimiter, closingDelimiter, isServerTag);
        this.staticString = isStatic ? startDelimiter + closingDelimiter : null;
    }

    protected final boolean isStatic() {
        return this.staticString != null;
    }

    public String generateHTML(String startTagName) {
        return this.staticString != null ? this.staticString : "</" + startTagName + this.getClosingDelimiter();
    }

    protected Tag constructTagAt(Source source, int pos) {
        ParseText parseText = source.getParseText();
        int nameBegin = pos + "</".length();
        String name = null;
        int startDelimiterEnd = pos + this.getStartDelimiter().length();
        int end = -1;
        if (this.isStatic()) {
            name = this.getNamePrefix();
            if (!parseText.containsAt(this.getClosingDelimiter(), startDelimiterEnd)) {
                if (source.logger.isInfoEnabled()) {
                    source.logger.info(source.getRowColumnVector(pos).appendTo(new StringBuffer(200).append("EndTag of expected format ").append(this.staticString).append(" at ")).append(" not recognised as type '").append(this.getDescription()).append("' because it is missing the closing delimiter").toString());
                }
                return null;
            }
            end = startDelimiterEnd + this.getClosingDelimiter().length();
        } else {
            int nameEnd = source.findNameEnd(startDelimiterEnd);
            if (nameEnd == -1) {
                return null;
            }
            name = parseText.substring(nameBegin, nameEnd);
            if (!parseText.containsAt(this.getClosingDelimiter(), nameEnd)) {
                if (source.logger.isInfoEnabled()) {
                    source.logger.info(source.getRowColumnVector(pos).appendTo(new StringBuffer(200).append("EndTag ").append(name).append(" at ")).append(" not recognised as type '").append(this.getDescription()).append("' because its closing delimiter does not immediately follow its name").toString());
                }
                return null;
            }
            end = nameEnd + this.getClosingDelimiter().length();
        }
        return this.constructEndTag(source, pos, end, name);
    }
}

