/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.authorization;

import java.io.Serializable;
import java.util.Set;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.CacheInvalidator;
import org.wso2.carbon.caching.core.authorization.AuthorizationCacheException;
import org.wso2.carbon.caching.core.authorization.AuthorizationKey;
import org.wso2.carbon.caching.core.authorization.AuthorizeCacheEntry;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;

public class AuthorizationCache {
    private static Log log = LogFactory.getLog(AuthorizationCache.class);
    public static final String AUTHORIZATION_CACHE_NAME = "AUTHORIZATION_CACHE";
    protected Cache cache = CarbonUtils.getLocalCache((String)"AUTHORIZATION_CACHE");
    private static AuthorizationCache authorizationCache = new AuthorizationCache();

    private AuthorizationCache() {
    }

    private boolean isCacheNull() {
        if (this.cache == null) {
            if (log.isDebugEnabled()) {
                StackTraceElement[] elemets = Thread.currentThread().getStackTrace();
                String traceString = "";
                for (int i = 1; i < elemets.length; ++i) {
                    traceString = traceString + elemets[i] + System.getProperty("line.separator");
                }
                log.debug((Object)("AUTHORIZATION_CACHE doesn't exist in CacheManager:\n" + traceString));
            }
            return true;
        }
        return false;
    }

    public static AuthorizationCache getInstance() {
        return authorizationCache;
    }

    public void addToCache(String serverId, int tenantId, String userName, String resourceId, String action, boolean isAuthorized) {
        if (this.isCacheNull()) {
            return;
        }
        AuthorizationKey key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action);
        if (this.cache.containsKey((Object)key)) {
            this.cache.remove((Object)key);
        }
        AuthorizeCacheEntry cacheEntry = new AuthorizeCacheEntry(isAuthorized);
        this.cache.put((Object)key, (Object)cacheEntry);
    }

    public Boolean isUserAuthorized(String serverId, int tenantId, String userName, String resourceId, String action) throws AuthorizationCacheException {
        if (this.isCacheNull()) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        AuthorizationKey key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action);
        if (!this.cache.containsKey((Object)key)) {
            throw new AuthorizationCacheException("Authorization information not found in the cache.");
        }
        AuthorizeCacheEntry entry = (AuthorizeCacheEntry)this.cache.get((Object)key);
        if (entry != null) {
            return entry.isUserAuthorized();
        }
        return null;
    }

    public void clearCache() {
        if (this.isCacheNull()) {
            return;
        }
        this.cache.clear();
    }

    public void clearCacheEntry(String serverId, int tenantId, String userName, String resourceId, String action) {
        if (this.isCacheNull()) {
            return;
        }
        AuthorizationKey key = new AuthorizationKey(serverId, tenantId, userName, resourceId, action);
        if (this.cache.containsKey((Object)key)) {
            this.cache.remove((Object)key);
            CacheInvalidator invalidator = UMListenerServiceComponent.getCacheInvalidator();
            try {
                if (invalidator != null) {
                    invalidator.invalidateCache(AUTHORIZATION_CACHE_NAME, (Serializable)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Calling invalidation cache");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Not calling invalidation cache");
                }
            }
            catch (CacheException e) {
                log.error((Object)"Error while invalidating cache", (Throwable)e);
            }
        }
    }

    public void clearCacheByUser(int tenantId, String userName) {
        if (this.isCacheNull()) {
            return;
        }
        Set objectSect = this.cache.keySet();
        for (Object anObjectSect : objectSect) {
            AuthorizationKey key = (AuthorizationKey)anObjectSect;
            if (key.getTenantId() != tenantId || !key.getUserName().equals(userName)) continue;
            this.cache.remove((Object)key);
        }
    }

    public double hitRate() {
        if (this.isCacheNull()) {
            return 0.0;
        }
        CacheStatistics stats = this.cache.getCacheStatistics();
        return (double)stats.getCacheHits() / (double)(stats.getCacheHits() + stats.getCacheMisses());
    }

    public void clearCacheByTenant(int tenantId) {
        if (this.isCacheNull()) {
            return;
        }
        Set cacheKeySet = this.cache.keySet();
        for (Object cacheKey : cacheKeySet) {
            AuthorizationKey authzKey = (AuthorizationKey)cacheKey;
            if (tenantId != authzKey.getTenantId()) continue;
            this.cache.remove((Object)authzKey);
        }
        CacheInvalidator invalidator = UMListenerServiceComponent.getCacheInvalidator();
        try {
            if (invalidator != null) {
                invalidator.invalidateCache(AUTHORIZATION_CACHE_NAME, (Serializable)Integer.valueOf(tenantId));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Calling invalidation cache");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not calling invalidation cache");
            }
        }
        catch (CacheException e) {
            log.error((Object)"Error while invalidating cache", (Throwable)e);
        }
    }

    public void clearCacheByServerId(String serverId) {
        if (this.isCacheNull() || serverId == null) {
            return;
        }
        Set cacheKeySet = this.cache.keySet();
        for (Object cacheKey : cacheKeySet) {
            AuthorizationKey authzKey = (AuthorizationKey)cacheKey;
            if (!serverId.equals(authzKey.getServerId())) continue;
            this.cache.remove((Object)authzKey);
        }
    }

    public void clearCacheByResource(String serverId, int tenantID, String resourceID) {
        if (this.isCacheNull()) {
            return;
        }
        Set cacheKeySet = this.cache.keySet();
        for (Object cacheKey : cacheKeySet) {
            AuthorizationKey authzKey = (AuthorizationKey)cacheKey;
            if (tenantID != authzKey.getTenantId() || !resourceID.equals(authzKey.getResourceId()) || serverId != null && !serverId.equals(authzKey.getServerId())) continue;
            this.cache.remove((Object)authzKey);
        }
    }

    public void disableCache() {
        this.cache = null;
    }
}

