/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.dao.ClaimDAO;

public class DefaultClaimManager
implements ClaimManager {
    private Map<String, ClaimMapping> claimMapping = new ConcurrentHashMap<String, ClaimMapping>();
    private ClaimDAO claimDAO = null;

    public DefaultClaimManager(Map<String, ClaimMapping> claimMapping, DataSource dataSource, int tenantId) {
        this.claimMapping.putAll(claimMapping);
        this.claimDAO = new ClaimDAO(dataSource, tenantId);
    }

    public String getAttributeName(String claimURI) throws UserStoreException {
        ClaimMapping mapping = this.claimMapping.get(claimURI);
        if (mapping != null) {
            return mapping.getMappedAttribute();
        }
        return null;
    }

    public Claim getClaim(String claimURI) throws UserStoreException {
        ClaimMapping mapping = this.claimMapping.get(claimURI);
        if (mapping != null) {
            return mapping.getClaim();
        }
        return null;
    }

    public ClaimMapping getClaimMapping(String claimURI) throws UserStoreException {
        return this.claimMapping.get(claimURI);
    }

    public Claim[] getAllSupportClaimsByDefault() throws UserStoreException {
        ArrayList<Claim> claimList = new ArrayList<Claim>();
        Iterator<Map.Entry<String, ClaimMapping>> iterator = this.claimMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            ClaimMapping claimMapping = iterator.next().getValue();
            Claim claim = claimMapping.getClaim();
            if (!claim.isSupportedByDefault()) continue;
            claimList.add(claim);
        }
        return claimList.toArray(new Claim[claimList.size()]);
    }

    public Claim[] getAllClaims() throws UserStoreException {
        ArrayList<Claim> claimList = null;
        claimList = new ArrayList<Claim>();
        Iterator<Map.Entry<String, ClaimMapping>> iterator = this.claimMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            ClaimMapping claimMapping = iterator.next().getValue();
            Claim claim = claimMapping.getClaim();
            claimList.add(claim);
        }
        return claimList.toArray(new Claim[claimList.size()]);
    }

    public Claim[] getAllClaims(String dialectUri) throws UserStoreException {
        ArrayList<Claim> claimList = null;
        claimList = new ArrayList<Claim>();
        Iterator<Map.Entry<String, ClaimMapping>> iterator = this.claimMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            ClaimMapping claimMapping = iterator.next().getValue();
            Claim claim = claimMapping.getClaim();
            if (!claim.getDialectURI().equals(dialectUri)) continue;
            claimList.add(claim);
        }
        return claimList.toArray(new Claim[claimList.size()]);
    }

    public Claim[] getAllRequiredClaims() throws UserStoreException {
        ArrayList<Claim> claimList = null;
        claimList = new ArrayList<Claim>();
        Iterator<Map.Entry<String, ClaimMapping>> iterator = this.claimMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Claim claim = iterator.next().getValue().getClaim();
            if (!claim.isRequired()) continue;
            claimList.add(claim);
        }
        return claimList.toArray(new Claim[claimList.size()]);
    }

    public String[] getAllClaimUris() throws UserStoreException {
        return this.claimMapping.keySet().toArray(new String[this.claimMapping.size()]);
    }

    public void addNewClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws org.wso2.carbon.user.api.UserStoreException {
        this.addNewClaimMapping((ClaimMapping)mapping);
    }

    public void addNewClaimMapping(ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null && !this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
            this.claimMapping.put(mapping.getClaim().getClaimUri(), mapping);
            this.claimDAO.addClaimMapping(mapping);
        }
    }

    public void deleteClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null && this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
            this.claimMapping.remove(mapping.getClaim().getClaimUri());
            this.claimDAO.deleteClaimMapping((ClaimMapping)mapping);
        }
    }

    public void updateClaimMapping(org.wso2.carbon.user.api.ClaimMapping mapping) throws UserStoreException {
        if (mapping != null && mapping.getClaim() != null && this.claimMapping.containsKey(mapping.getClaim().getClaimUri())) {
            this.claimMapping.put(mapping.getClaim().getClaimUri(), (ClaimMapping)mapping);
            this.claimDAO.updateClaim((ClaimMapping)mapping);
        }
    }
}

