/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.claim.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.claim.builder.ClaimBuilderException;
import org.wso2.carbon.user.core.claim.dao.ClaimDAO;
import org.wso2.carbon.utils.CarbonUtils;

public class ClaimBuilder {
    public static final String LOCAL_NAME_DIALECTS = "Dialects";
    public static final String LOCAL_NAME_DIALECT = "Dialect";
    public static final String LOCAL_NAME_CLAIM = "Claim";
    public static final String LOCAL_NAME_CLAIM_URI = "ClaimURI";
    public static final String LOCAL_NAME_DISPLAY_NAME = "DisplayName";
    public static final String LOCAL_NAME_DESCRIPTION = "Description";
    public static final String LOCAL_NAME_REQUIRED = "Required";
    public static final String LOCAL_NAME_SUPPORTED_BY_DEFAULT = "SupportedByDefault";
    public static final String LOCAL_NAME_REG_EX = "RegEx";
    public static final String LOCAL_NAME_ATTR_ID = "AttributeID";
    public static final String LOCAL_NAME_PROFILES = "Profiles";
    public static final String LOCAL_NAME_PROFILE = "Profile";
    public static final String LOCAL_NAME_CLAIM_BEHAVIOR = "ClaimBehavior";
    public static final String LOCAL_NAME_DISPLAY_OREDR = "DisplayOrder";
    public static final String ATTR_DIALECT_URI = "dialectURI";
    private static Log log = LogFactory.getLog(ClaimBuilder.class);
    private static final String CLAIM_CONFIG = "claim-config.xml";
    InputStream inStream = null;
    int tenantId;
    private static BundleContext bundleContext;

    public ClaimBuilder(int tenantId) {
        this.tenantId = tenantId;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        ClaimBuilder.bundleContext = bundleContext;
    }

    public Map<String, ClaimMapping> buildClaimMappingsFromDatabase(DataSource ds, String realmName) throws ClaimBuilderException {
        HashMap<String, ClaimMapping> claims = new HashMap<String, ClaimMapping>();
        try {
            ClaimDAO claimDAO = new ClaimDAO(ds, this.tenantId);
            List<ClaimMapping> lst = claimDAO.loadClaimMappings();
            for (ClaimMapping cm : lst) {
                String uri = cm.getClaim().getClaimUri();
                claims.put(uri, cm);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        return claims;
    }

    public Map<String, ClaimMapping> buildClaimMappingsFromConfigFile() throws ClaimBuilderException {
        OMElement element = null;
        OMElement dialectRoot = null;
        String message = null;
        Iterator dialectIterator = null;
        HashMap<String, ClaimMapping> claims = null;
        try {
            element = this.getRootElement();
        }
        catch (Exception e) {
            message = "Error while reading claim configuration";
            log.error((Object)message, (Throwable)e);
            throw new ClaimBuilderException(message, e);
        }
        dialectRoot = element.getFirstChildWithName(new QName(LOCAL_NAME_DIALECTS));
        if (dialectRoot == null) {
            message = "In valid schema <Dialects> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new ClaimBuilderException(message);
        }
        dialectIterator = dialectRoot.getChildrenWithLocalName(LOCAL_NAME_DIALECT);
        claims = new HashMap<String, ClaimMapping>();
        while (dialectIterator.hasNext()) {
            OMElement dialect = null;
            String dialectUri = null;
            Iterator claimIterator = null;
            dialect = (OMElement)dialectIterator.next();
            dialectUri = dialect.getAttribute(new QName(ATTR_DIALECT_URI)).getAttributeValue();
            claimIterator = dialect.getChildrenWithLocalName(LOCAL_NAME_CLAIM);
            while (claimIterator.hasNext()) {
                OMElement claimElement = null;
                Claim claim = null;
                ClaimMapping claimMapping = null;
                String displayName = null;
                String claimUri = null;
                String attributeId = null;
                String description = null;
                String regEx = null;
                int displayOrder = 0;
                claimElement = (OMElement)claimIterator.next();
                this.validateSchema(claimElement);
                claim = new Claim();
                claim.setDialectURI(dialectUri);
                claimUri = claimElement.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_URI)).getText();
                claim.setClaimUri(claimUri);
                if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DISPLAY_NAME)) != null) {
                    displayName = claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DISPLAY_NAME)).getText();
                    claim.setDisplayTag(displayName);
                }
                description = claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DESCRIPTION)).getText();
                claim.setDescription(description);
                if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_REG_EX)) != null) {
                    regEx = claimElement.getFirstChildWithName(new QName(LOCAL_NAME_REG_EX)).getText();
                    claim.setRegEx(regEx);
                }
                if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_REQUIRED)) != null) {
                    claim.setRequired(true);
                }
                if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_SUPPORTED_BY_DEFAULT)) != null) {
                    claim.setSupportedByDefault(true);
                }
                if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DISPLAY_OREDR)) != null) {
                    displayOrder = Integer.parseInt(claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DISPLAY_OREDR)).getText());
                    claim.setDisplayOrder(displayOrder);
                }
                attributeId = claimElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_ID)).getText();
                claimMapping = new ClaimMapping(claim, attributeId);
                claims.put(claimUri, claimMapping);
            }
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ClaimBuilderException(e.getMessage(), e);
        }
        return claims;
    }

    private void validateSchema(OMElement claimElement) throws ClaimBuilderException {
        String message = null;
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_CLAIM_URI)) == null) {
            message = "In valid schema <ClaimUri> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new ClaimBuilderException(message);
        }
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_DESCRIPTION)) == null) {
            message = "In valid schema <Description> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new ClaimBuilderException(message);
        }
        if (claimElement.getFirstChildWithName(new QName(LOCAL_NAME_ATTR_ID)) == null) {
            message = "In valid schema <AttributeId> element not present";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new ClaimBuilderException(message);
        }
    }

    private OMElement getRootElement() throws XMLStreamException, IOException, ClaimBuilderException {
        StAXOMBuilder builder = null;
        File claimConfigXml = new File(CarbonUtils.getCarbonConfigDirPath(), CLAIM_CONFIG);
        if (claimConfigXml.exists()) {
            this.inStream = new FileInputStream(claimConfigXml);
        }
        String warningMessage = "";
        if (this.inStream == null) {
            URL url;
            if (bundleContext != null) {
                url = bundleContext.getBundle().getResource(CLAIM_CONFIG);
                if (url != null) {
                    this.inStream = url.openStream();
                } else {
                    warningMessage = "Bundle context could not find resource claim-config.xml or user does not have sufficient permission to access the resource.";
                }
            } else {
                url = this.getClass().getClassLoader().getResource(CLAIM_CONFIG);
                if (url != null) {
                    this.inStream = url.openStream();
                } else {
                    warningMessage = "ClaimBuilder could not find resource claim-config.xml or user does not have sufficient permission to access the resource.";
                }
            }
        }
        if (this.inStream == null) {
            String message = "Claim configuration not found. Cause - " + warningMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new FileNotFoundException(message);
        }
        builder = new StAXOMBuilder(this.inStream);
        OMElement documentElement = builder.getDocumentElement();
        return documentElement;
    }
}

