/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.rdbms.RDBMSConfiguration;
import org.wso2.carbon.ndatasource.rdbms.RDBMSDataSource;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;

public class DatabaseUtil {
    private static Log log = LogFactory.getLog(DatabaseUtil.class);
    private static long connectionsCreated;
    private static long connectionsClosed;
    private static ExecutorService executor;
    private static javax.sql.DataSource dataSource;
    private static final int DEFAULT_MAX_ACTIVE = 40;
    private static final int DEFAULT_MAX_WAIT = 60000;
    private static final int DEFAULT_MIN_IDLE = 5;
    private static final int DEFAULT_MAX_IDLE = 6;

    public static synchronized javax.sql.DataSource getRealmDataSource(RealmConfiguration realmConfig) {
        if (dataSource == null) {
            return DatabaseUtil.createRealmDataSource(realmConfig);
        }
        return dataSource;
    }

    public static synchronized void closeDatabasePoolConnection() {
        if (dataSource != null && dataSource instanceof DataSource) {
            ((DataSource)dataSource).close();
            dataSource = null;
        }
    }

    private static javax.sql.DataSource lookupDataSource(String dataSourceName) {
        try {
            return (javax.sql.DataSource)InitialContext.doLookup(dataSourceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in looking up data source: " + e.getMessage(), e);
        }
    }

    public static javax.sql.DataSource createUserStoreDataSource(RealmConfiguration realmConfig) {
        String dataSourceName = realmConfig.getUserStoreProperty("dataSource");
        if (dataSourceName != null) {
            return DatabaseUtil.lookupDataSource(dataSourceName);
        }
        RDBMSConfiguration dsConfig = new RDBMSConfiguration();
        dsConfig.setDriverClassName(realmConfig.getUserStoreProperty("driverName"));
        if (dsConfig.getDriverClassName() == null) {
            return null;
        }
        dsConfig.setUrl(realmConfig.getUserStoreProperty("url"));
        dsConfig.setUsername(realmConfig.getUserStoreProperty("userName"));
        dsConfig.setPassword(realmConfig.getUserStoreProperty("password"));
        if (realmConfig.getUserStoreProperty("maxActive") != null && !realmConfig.getUserStoreProperty("maxActive").equals("")) {
            dsConfig.setMaxActive(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("maxActive"))));
        } else {
            dsConfig.setMaxActive(Integer.valueOf(40));
        }
        if (realmConfig.getUserStoreProperty("minIdle") != null && !realmConfig.getUserStoreProperty("minIdle").equals("")) {
            dsConfig.setMinIdle(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("minIdle"))));
        } else {
            dsConfig.setMinIdle(Integer.valueOf(5));
        }
        if (realmConfig.getUserStoreProperty("maxIdle") != null && !realmConfig.getUserStoreProperty("maxIdle").equals("")) {
            dsConfig.setMinIdle(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("maxIdle"))));
        } else {
            dsConfig.setMinIdle(Integer.valueOf(6));
        }
        if (realmConfig.getUserStoreProperty("maxWait") != null && !realmConfig.getUserStoreProperty("maxWait").equals("")) {
            dsConfig.setMaxWait(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("maxWait"))));
        } else {
            dsConfig.setMaxWait(Integer.valueOf(60000));
        }
        if (realmConfig.getUserStoreProperty("testWhileIdle") != null && !realmConfig.getUserStoreProperty("testWhileIdle").equals("")) {
            dsConfig.setTestWhileIdle(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getUserStoreProperty("testWhileIdle"))));
        }
        if (realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis") != null && !realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis").equals("")) {
            dsConfig.setTimeBetweenEvictionRunsMillis(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis"))));
        }
        if (realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis") != null && !realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis").equals("")) {
            dsConfig.setMinEvictableIdleTimeMillis(Integer.valueOf(Integer.parseInt(realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis"))));
        }
        if (realmConfig.getUserStoreProperty("validationQuery") != null) {
            dsConfig.setValidationQuery(realmConfig.getUserStoreProperty("validationQuery"));
        }
        try {
            return new RDBMSDataSource(dsConfig).getDataSource();
        }
        catch (DataSourceException e) {
            throw new RuntimeException("Error in creating data source: " + e.getMessage(), e);
        }
    }

    private static javax.sql.DataSource createRealmDataSource(RealmConfiguration realmConfig) {
        String dataSourceName = realmConfig.getRealmProperty("dataSource");
        if (dataSourceName != null) {
            return DatabaseUtil.lookupDataSource(dataSourceName);
        }
        RDBMSConfiguration dsConfig = new RDBMSConfiguration();
        dsConfig.setDriverClassName(realmConfig.getRealmProperty("driverName"));
        dsConfig.setUrl(realmConfig.getRealmProperty("url"));
        dsConfig.setUsername(realmConfig.getRealmProperty("userName"));
        dsConfig.setPassword(realmConfig.getRealmProperty("password"));
        if (realmConfig.getRealmProperty("maxActive") != null && !realmConfig.getRealmProperty("maxActive").equals("")) {
            dsConfig.setMaxActive(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("maxActive"))));
        } else {
            dsConfig.setMaxActive(Integer.valueOf(40));
        }
        if (realmConfig.getRealmProperty("minIdle") != null && !realmConfig.getRealmProperty("minIdle").equals("")) {
            dsConfig.setMinIdle(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("minIdle"))));
        } else {
            dsConfig.setMinIdle(Integer.valueOf(5));
        }
        if (realmConfig.getRealmProperty("maxIdle") != null && !realmConfig.getRealmProperty("maxIdle").equals("")) {
            dsConfig.setMinIdle(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("maxIdle"))));
        } else {
            dsConfig.setMinIdle(Integer.valueOf(6));
        }
        if (realmConfig.getRealmProperty("maxWait") != null && !realmConfig.getRealmProperty("maxWait").equals("")) {
            dsConfig.setMaxWait(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("maxWait"))));
        } else {
            dsConfig.setMaxWait(Integer.valueOf(60000));
        }
        if (realmConfig.getRealmProperty("testWhileIdle") != null && !realmConfig.getRealmProperty("testWhileIdle").equals("")) {
            dsConfig.setTestWhileIdle(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getRealmProperty("testWhileIdle"))));
        }
        if (realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis") != null && !realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis").equals("")) {
            dsConfig.setTimeBetweenEvictionRunsMillis(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis"))));
        }
        if (realmConfig.getRealmProperty("minEvictableIdleTimeMillis") != null && !realmConfig.getRealmProperty("minEvictableIdleTimeMillis").equals("")) {
            dsConfig.setMinEvictableIdleTimeMillis(Integer.valueOf(Integer.parseInt(realmConfig.getRealmProperty("minEvictableIdleTimeMillis"))));
        }
        if (realmConfig.getRealmProperty("validationQuery") != null) {
            dsConfig.setValidationQuery(realmConfig.getRealmProperty("validationQuery"));
        }
        try {
            dataSource = new RDBMSDataSource(dsConfig).getDataSource();
            return dataSource;
        }
        catch (DataSourceException e) {
            throw new RuntimeException("Error in creating data source: " + e.getMessage(), e);
        }
    }

    public static String[] getStringValuesFromDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        String[] stringArray;
        String[] values = new String[]{};
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Null data provided.");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (!(param instanceof Integer)) continue;
                    prepStmt.setInt(i + 1, (Integer)param);
                }
            }
            rs = prepStmt.executeQuery();
            ArrayList<String> lst = new ArrayList<String>();
            while (rs.next()) {
                String name = rs.getString(1);
                lst.add(name);
            }
            if (lst.size() > 0) {
                values = lst.toArray(new String[lst.size()]);
            }
            stringArray = values;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return stringArray;
    }

    public static int getIntegerValueFromDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        int i;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int value = -1;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Null data provided.");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (!(param instanceof Integer)) continue;
                    prepStmt.setInt(i + 1, (Integer)param);
                }
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                value = rs.getInt(1);
            }
            i = value;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void udpateUserRoleMappingInBatchMode(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block14: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                int batchParamIndex = -1;
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Null data provided.");
                        }
                        if (param instanceof String[]) {
                            batchParamIndex = i;
                            continue;
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (!(param instanceof Integer)) continue;
                        prepStmt.setInt(i + 1, (Integer)param);
                    }
                }
                if (batchParamIndex != -1) {
                    String[] values;
                    for (String value : values = (String[])params[batchParamIndex]) {
                        prepStmt.setString(batchParamIndex + 1, value);
                        prepStmt.addBatch();
                    }
                }
                int[] count = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed a batch update. Querry is : " + sqlStmt + ": and result is" + Arrays.toString(count)));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block14;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    log.error((Object)("Using sql : " + sqlStmt));
                    throw new UserStoreException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public static void udpateRolePermissionsInBatchMode(Connection dbConnection, String sqlStmt, Integer[] permissionIds, String roleName, short allow, Integer tenentId) throws UserStoreException {
        PreparedStatement prepStmt = null;
        boolean localConnection = false;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            int batchParamIndex = -1;
            for (Integer id : permissionIds) {
                prepStmt.setInt(1, id);
                prepStmt.setString(2, roleName);
                prepStmt.setShort(3, allow);
                prepStmt.setInt(4, tenentId);
                prepStmt.addBatch();
            }
            int[] count = prepStmt.executeBatch();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executed a batch update. Querry is : " + sqlStmt + ": and result is" + Arrays.toString(count)));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public static void updateDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Null data provided.");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        prepStmt.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        prepStmt.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (!(param instanceof Date)) continue;
                    Date date = (Date)param;
                    Timestamp time = new Timestamp(date.getTime());
                    prepStmt.setTimestamp(i + 1, time);
                }
            }
            int count = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executed querry is " + sqlStmt + " and number of updated rows :: " + count));
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error! " + e.getMessage()), (Throwable)e);
                log.error((Object)("Using sql : " + sqlStmt));
                throw new UserStoreException("Error! " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public static Connection getDBConnection(javax.sql.DataSource dataSource) throws SQLException {
        Connection dbConnection = dataSource.getConnection();
        DatabaseUtil.incrementConnectionsCreated();
        return dbConnection;
    }

    public static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
                DatabaseUtil.incrementConnectionsClosed();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close result set  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatements(PreparedStatement ... prepStmts) {
        if (prepStmts != null && prepStmts.length > 0) {
            for (PreparedStatement stmt : prepStmts) {
                DatabaseUtil.closeStatement(stmt);
            }
        }
    }

    public static void closeAllConnections(Connection dbConnection, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeResultSet(rs);
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs1, ResultSet rs2, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeResultSet(rs1);
        DatabaseUtil.closeResultSet(rs1);
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void rollBack(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }

    public static long getConnectionsCreated() {
        return connectionsCreated;
    }

    public static long getConnectionsClosed() {
        return connectionsClosed;
    }

    public static synchronized void incrementConnectionsCreated() {
        if (connectionsCreated != Long.MAX_VALUE) {
            ++connectionsCreated;
        }
    }

    public static synchronized void incrementConnectionsClosed() {
        if (connectionsClosed != Long.MAX_VALUE) {
            ++connectionsClosed;
        }
    }

    public static void logDatabaseConnections() {
        executor = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdownNow();
            }
        });
        final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                scheduler.shutdownNow();
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.debug((Object)("Total Number of Connections Created      : " + DatabaseUtil.getConnectionsCreated()));
                log.debug((Object)("Total Number of Connections Closed       : " + DatabaseUtil.getConnectionsClosed()));
            }
        };
        scheduler.scheduleAtFixedRate(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    static {
        executor = null;
        dataSource = null;
    }
}

