/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.services.prov.utils;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.util.IUPropertyUtils;
import org.wso2.carbon.feature.mgt.core.util.ProvisioningUtils;
import org.wso2.carbon.feature.mgt.core.util.RepositoryUtils;
import org.wso2.carbon.feature.mgt.services.prov.data.CopyrightInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.Feature;
import org.wso2.carbon.feature.mgt.services.prov.data.FeatureInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.LicenseInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.ProfileHistory;
import org.wso2.carbon.feature.mgt.services.prov.data.ProvisioningActionResultInfo;
import org.wso2.carbon.feature.mgt.services.prov.data.RepositoryInfo;

public class ProvWSUtils {
    public static RepositoryInfo[] wrapURIsAsRepositories(URI[] uriArray) throws ProvisioningException {
        if (uriArray == null) {
            return new RepositoryInfo[0];
        }
        RepositoryInfo[] repositories = new RepositoryInfo[uriArray.length];
        for (int index = 0; index < uriArray.length; ++index) {
            RepositoryInfo repository;
            URI location = uriArray[index];
            boolean enabled = RepositoryUtils.isRepositoryEnabled((URI)location);
            String nickName = RepositoryUtils.getMetadataRepositoryProperty((URI)location, (String)"p2.nickname");
            if (nickName == null) {
                nickName = RepositoryUtils.getMetadataRepositoryProperty((URI)location, (String)"name");
            }
            if (nickName == null) {
                nickName = " ";
            }
            repositories[index] = repository = new RepositoryInfo(location.toString(), nickName, enabled);
        }
        return repositories;
    }

    public static URI[] mergeURIArrays(URI[] array1, URI[] array2) {
        int arrayLength = array1.length + array2.length;
        URI[] mergedArray = new URI[arrayLength];
        System.arraycopy(array1, 0, mergedArray, 0, array1.length);
        System.arraycopy(array2, 0, mergedArray, array1.length, array2.length);
        return mergedArray;
    }

    public static FeatureInfo[] wrapIUsAsFeatures(IInstallableUnit[] installableUnits) {
        if (installableUnits == null) {
            return new FeatureInfo[0];
        }
        FeatureInfo[] features = new FeatureInfo[installableUnits.length];
        for (int index = 0; index < installableUnits.length; ++index) {
            FeatureInfo feature = new FeatureInfo();
            IInstallableUnit installableUnit = installableUnits[index];
            features[index] = feature;
            feature.setFeatureID(installableUnit.getId());
            feature.setFeatureVersion(installableUnit.getVersion().toString());
            feature.setFeatureName(IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.name"));
            String provider = IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.provider");
            if (provider == null) {
                provider = " ";
            }
            feature.setProvider(provider);
            String description = IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.description");
            if (description == null) {
                description = "No description provided";
            }
            feature.setDescription(description);
        }
        return features;
    }

    public static Feature[] wrapInstalledFeatures(IInstallableUnit[] installableUnits, IQueryable queryable) {
        if (installableUnits == null) {
            return new Feature[0];
        }
        HashMap<String, IInstallableUnit> installedFeaturesMap = ProvWSUtils.getInstalledUnitsMap(installableUnits);
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        for (IInstallableUnit iu : installableUnits) {
            if (iu.getId().startsWith("org.eclipse.equinox") || iu.getId().startsWith("carbon.product.id")) continue;
            featuresList.add(ProvWSUtils.processFeature(iu, (IQueryable<IInstallableUnit>)queryable, installedFeaturesMap));
        }
        return featuresList.toArray(new Feature[featuresList.size()]);
    }

    public static Feature[] wrapAvailableFeatures(IInstallableUnit[] availableInstallableUnits, IInstallableUnit[] installedInstallableUnits, IQueryable queryable) {
        if (availableInstallableUnits == null) {
            return new Feature[0];
        }
        HashMap<String, IInstallableUnit> installedFeaturesMap = ProvWSUtils.getInstalledUnitsMap(installedInstallableUnits);
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        for (IInstallableUnit iu : availableInstallableUnits) {
            if (iu.getId().startsWith("org.eclipse.equinox") || ProvisioningUtils.isIUInstalled((IInstallableUnit)iu, installedFeaturesMap)) continue;
            featuresList.add(ProvWSUtils.processFeature(iu, (IQueryable<IInstallableUnit>)queryable, installedFeaturesMap));
        }
        return featuresList.toArray(new Feature[featuresList.size()]);
    }

    public static Feature processFeature(IInstallableUnit iu, IQueryable<IInstallableUnit> queryable, HashMap<String, IInstallableUnit> installedFeaturesMap) {
        Feature groupFeature = ProvWSUtils.wrapIU(iu);
        Stack<IInstallableUnit> iuStack = new Stack<IInstallableUnit>();
        Stack<Feature> featureStack = new Stack<Feature>();
        iuStack.add(iu);
        featureStack.add(groupFeature);
        while (!iuStack.isEmpty() && !featureStack.isEmpty()) {
            IInstallableUnit popedIU = (IInstallableUnit)iuStack.pop();
            Feature popedFeature = (Feature)featureStack.pop();
            if (popedFeature.isInstalled()) {
                popedFeature.setRequiredFeatures(new Feature[0]);
                continue;
            }
            ArrayList<Feature> requiredFeaturesList = new ArrayList<Feature>();
            Collection requiredCapabilities = popedIU.getRequirements();
            for (IRequirement requiredCapability : requiredCapabilities) {
                IInstallableUnit[] requiredInstallableUnits;
                IMatchExpression matchExpression = requiredCapability.getMatches();
                IQuery query = QueryUtil.createMatchQuery(IInstallableUnit.class, (IExpression)matchExpression, (Object[])new Object[0]);
                for (IInstallableUnit installableUnit : requiredInstallableUnits = (IInstallableUnit[])queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class)) {
                    IInstallableUnit requiredIU;
                    if (!installableUnit.getId().endsWith("feature.group") || installableUnit.getId().startsWith("org.eclipse.equinox")) continue;
                    IInstallableUnit iInstallableUnit = requiredIU = requiredInstallableUnits.length == 0 ? null : requiredInstallableUnits[0];
                    if (requiredIU == null) continue;
                    Feature requiredFeature = ProvWSUtils.wrapIU(requiredIU);
                    if (ProvisioningUtils.isIUInstalled((IInstallableUnit)requiredIU, installedFeaturesMap)) continue;
                    requiredFeature.setRequired(true);
                    iuStack.push(requiredIU);
                    featureStack.add(requiredFeature);
                    requiredFeaturesList.add(requiredFeature);
                }
            }
            popedFeature.setRequiredFeatures(requiredFeaturesList.toArray(new Feature[requiredFeaturesList.size()]));
        }
        return groupFeature;
    }

    public static Feature wrapIU(IInstallableUnit iu) {
        Feature feature = new Feature();
        feature.setFeatureID(iu.getId());
        feature.setFeatureVersion(iu.getVersion().toString());
        feature.setFeatureName(IUPropertyUtils.getIUProperty((IInstallableUnit)iu, (String)"org.eclipse.equinox.p2.name"));
        String provider = IUPropertyUtils.getIUProperty((IInstallableUnit)iu, (String)"org.eclipse.equinox.p2.provider");
        if (provider == null) {
            provider = " ";
        }
        feature.setProvider(provider);
        String featureType = iu.getProperty("org.wso2.carbon.p2.category.type");
        if (featureType == null) {
            featureType = iu.getProperty("org.eclipse.equinox.p2.type.category") != null && Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.category")) ? "org.eclipse.equinox.p2.type.category" : "";
        }
        feature.setFeatureType(featureType);
        String featureDescription = IUPropertyUtils.getIUProperty((IInstallableUnit)iu, (String)"org.eclipse.equinox.p2.description");
        if (featureDescription == null) {
            featureDescription = "";
        }
        feature.setFeatureDescription(featureDescription);
        return feature;
    }

    public static IInstallableUnit[] getRequiredFeatureIUs(IInstallableUnit featureIU, IQueryable queryable) {
        ArrayList<IInstallableUnit> requiredIUList = new ArrayList<IInstallableUnit>();
        Collection requiredCapabilities = featureIU.getRequirements();
        for (IRequirement requiredCapability : requiredCapabilities) {
            IMatchExpression matchExpression = requiredCapability.getMatches();
            IQuery query = QueryUtil.createMatchQuery((IExpression)matchExpression, (Object[])new Object[0]);
            Set requiredInstallableUnits = queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
            for (IInstallableUnit installableUnit : requiredInstallableUnits) {
                if (!"org.eclipse.equinox.p2.iu".equals(installableUnit.getId()) || !installableUnit.getId().endsWith("feature.group") || installableUnit.getId().startsWith("org.eclipse.equinox")) continue;
                requiredIUList.add(installableUnit);
            }
        }
        IInstallableUnit[] requiredIUs = new IInstallableUnit[requiredIUList.size()];
        return requiredIUList.toArray(requiredIUs);
    }

    public static FeatureInfo wrapIUsAsFeaturesWithDetails(IInstallableUnit installableUnit, ILicense license, ICopyright copyright) {
        if (installableUnit == null) {
            return new FeatureInfo();
        }
        FeatureInfo feature = new FeatureInfo();
        feature.setFeatureID(installableUnit.getId());
        feature.setFeatureVersion(installableUnit.getVersion().toString());
        feature.setFeatureName(IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.name"));
        String provider = IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.provider");
        if (provider == null) {
            provider = " ";
        }
        feature.setProvider(provider);
        String description = IUPropertyUtils.getIUProperty((IInstallableUnit)installableUnit, (String)"org.eclipse.equinox.p2.description");
        if (description == null) {
            description = "No description provided";
        }
        feature.setDescription(description);
        if (license != null) {
            feature.setLicenseInfo(ProvWSUtils.wrapP2LicensesAsLicenses(new ILicense[]{license})[0]);
        }
        if (copyright != null) {
            feature.setCopyrightInfo(ProvWSUtils.wrapICopyrightAsCopyrightInfo(copyright));
        }
        return feature;
    }

    public static IInstallableUnit[] deriveRepositoryIUsFromFeatures(FeatureInfo[] features) throws ProvisioningException {
        if (features == null) {
            return new IInstallableUnit[0];
        }
        HashMap<String, IInstallableUnit> iuMap = new HashMap<String, IInstallableUnit>();
        for (FeatureInfo featureInfo : features) {
            IQuery query = QueryUtil.createIUQuery((String)featureInfo.getFeatureID(), (VersionRange)new VersionRange(Version.create((String)featureInfo.getFeatureVersion()), true, Version.create((String)featureInfo.getFeatureVersion()), true));
            IQueryable queryable = RepositoryUtils.getQuerybleRepositoryManager(null);
            IInstallableUnit[] installableUnits = (IInstallableUnit[])queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
            if (installableUnits[0] == null) continue;
            ProvWSUtils.addIUtoMap(iuMap, installableUnits[0]);
        }
        return iuMap.values().toArray(new IInstallableUnit[iuMap.values().size()]);
    }

    private static void addIUtoMap(HashMap<String, IInstallableUnit> iuMap, IInstallableUnit iu) {
        IInstallableUnit addedIU = iuMap.get(iu.getId());
        if (addedIU == null) {
            iuMap.put(iu.getId(), iu);
        } else if (addedIU.getVersion().compareTo((Object)iu.getVersion()) < 0) {
            iuMap.put(iu.getId(), iu);
        }
    }

    public static IInstallableUnit[] deriveProfileIUsFromFeatures(FeatureInfo[] features) throws ProvisioningException {
        if (features == null) {
            return new IInstallableUnit[0];
        }
        IInstallableUnit[] ius = new IInstallableUnit[features.length];
        for (int i = 0; i < features.length; ++i) {
            FeatureInfo feature = features[i];
            IQuery query = QueryUtil.createIUQuery((String)feature.getFeatureID(), (VersionRange)new VersionRange(feature.getFeatureVersion()));
            IInstallableUnit[] installableUnits = (IInstallableUnit[])ProvisioningUtils.getProfile().query(query, (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
            ius[i] = installableUnits[0];
        }
        return ius;
    }

    public static ProvisioningActionResultInfo wrapResolutionResult(ResolutionResult resolutionResult) {
        ProvisioningActionResultInfo resultInfo = new ProvisioningActionResultInfo();
        resultInfo.setReviewedInstallableFeatures(ProvWSUtils.wrapIUsAsFeatures(resolutionResult.getReviewedInstallableUnits()));
        resultInfo.setReviewedUninstallableFeatures(ProvWSUtils.wrapIUsAsFeatures(resolutionResult.getReviewedUninstallableUnits()));
        resultInfo.setFailedinstallableFeatures(ProvWSUtils.wrapIUsAsFeatures(resolutionResult.getFailedInstallableUnits()));
        resultInfo.setFailedUninstallableFeatures(ProvWSUtils.wrapIUsAsFeatures(resolutionResult.getFailedUninstallableUnits()));
        resultInfo.setDetailedDescription(resolutionResult.getSummaryReport());
        resultInfo.setSummary(resolutionResult.getSummaryReport());
        resultInfo.setSize(resolutionResult.getInstallationSize());
        return resultInfo;
    }

    public static void saveResolutionResult(String actionType, ResolutionResult resolutionResult, MessageContext messageContext) throws Exception {
        HttpSession session = ProvWSUtils.getHttpSession(messageContext);
        if (session == null) {
            throw new Exception("HttpSession is null");
        }
        session.setAttribute(actionType, (Object)resolutionResult);
    }

    public static ResolutionResult getResolutionResult(String actionType, MessageContext messageContext) throws Exception {
        HttpSession session = ProvWSUtils.getHttpSession(messageContext);
        if (session != null) {
            return (ResolutionResult)session.getAttribute(actionType);
        }
        throw new Exception("HttpSession is null");
    }

    public static LicenseInfo[] wrapP2LicensesAsLicenses(ILicense[] p2Licenses) {
        if (p2Licenses == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] licenses = new LicenseInfo[p2Licenses.length];
        for (int index = 0; index < licenses.length; ++index) {
            LicenseInfo license = new LicenseInfo();
            license.setBody(p2Licenses[index].getBody() == null ? "" : p2Licenses[index].getBody());
            license.setURL(p2Licenses[index].getLocation() == null ? "" : p2Licenses[index].getLocation().toString());
            licenses[index] = license;
        }
        return licenses;
    }

    public static CopyrightInfo wrapICopyrightAsCopyrightInfo(ICopyright iCopyright) {
        if (iCopyright == null) {
            return new CopyrightInfo();
        }
        CopyrightInfo copyrightInfo = new CopyrightInfo();
        copyrightInfo.setBody(iCopyright.getBody());
        copyrightInfo.setURL(iCopyright.getLocation() == null ? "" : iCopyright.getLocation().toString());
        return copyrightInfo;
    }

    public static ProfileHistory getProfileHistoryFromTimestamp(long timestamp) {
        ProfileHistory profileHistory = new ProfileHistory();
        profileHistory.setTimestamp(timestamp);
        SimpleDateFormat monthDayYearformatter = new SimpleDateFormat("MMMMM dd, yyyy 'at' HH:mm:ss z");
        Date date = new Date(timestamp);
        profileHistory.setSummary(monthDayYearformatter.format(date));
        return profileHistory;
    }

    public static HttpSession getHttpSession(MessageContext messageContext) {
        return (HttpSession)messageContext.getProperty("comp.mgt.servlet.session");
    }

    public static HashMap<String, IInstallableUnit> getInstalledUnitsMap(IInstallableUnit[] installedUnits) {
        HashMap<String, IInstallableUnit> installedUnitsMap = new HashMap<String, IInstallableUnit>(installedUnits.length);
        for (IInstallableUnit iu : installedUnits) {
            installedUnitsMap.put(iu.getId(), iu);
        }
        return installedUnitsMap;
    }
}

