/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.DbException;
import org.h2.schema.Schema;

public class CreateSchema
extends DefineCommand {
    private String schemaName;
    private String authorization;
    private boolean ifNotExists;

    public CreateSchema(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        User user = database.getUser(this.authorization);
        user.checkAdmin();
        if (database.findSchema(this.schemaName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90078, this.schemaName);
        }
        int n = this.getObjectId();
        Schema schema = new Schema(database, n, this.schemaName, user, false);
        database.addDatabaseObject(this.session, schema);
        return 0;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public void setAuthorization(String string) {
        this.authorization = string;
    }
}

