/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueString;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared prepared) {
        this.command = prepared;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    @Override
    public ResultInterface query(int n) {
        Column column = new Column("PLAN", 13);
        ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
        Expression[] expressionArray = new Expression[]{expressionColumn};
        this.result = new LocalResult(this.session, expressionArray, 1);
        if (n >= 0) {
            String string;
            if (this.executeCommand) {
                PageStore pageStore = this.session.getDatabase().getPageStore();
                pageStore.statisticsStart();
                if (this.command.isQuery()) {
                    this.command.query(n);
                } else {
                    this.command.update();
                }
                string = this.command.getPlanSQL();
                AbstractMap abstractMap = pageStore.statisticsEnd();
                if (abstractMap != null) {
                    int n2 = 0;
                    for (Map.Entry object : abstractMap.entrySet()) {
                        n2 += ((Integer)object.getValue()).intValue();
                    }
                    if (n2 > 0) {
                        abstractMap = new TreeMap<String, Integer>(abstractMap);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("total: ").append(n2).append('\n');
                        for (Map.Entry entry : abstractMap.entrySet()) {
                            int n3 = (Integer)entry.getValue();
                            int n4 = (int)(100L * (long)n3 / (long)n2);
                            stringBuilder.append((String)entry.getKey()).append(": ").append(n3).append(" (").append(n4).append("%)\n");
                        }
                        string = string + "\n/*\n" + stringBuilder.toString() + "*/";
                    }
                }
            } else {
                string = this.command.getPlanSQL();
            }
            this.add(string);
        }
        this.result.done();
        return this.result;
    }

    private void add(String string) {
        Value[] valueArray = new Value[]{ValueString.get(string)};
        this.result.addRow(valueArray);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

