/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectOrderBy;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class SelectUnion
extends Query {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int EXCEPT = 2;
    public static final int INTERSECT = 3;
    private int unionType;
    private Query left;
    private Query right;
    private ArrayList<Expression> expressions;
    private Expression[] expressionArray;
    private ArrayList<SelectOrderBy> orderList;
    private SortOrder sort;
    private boolean distinct;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean isForUpdate;

    public SelectUnion(Session session, Query query) {
        super(session);
        this.left = query;
    }

    public void setUnionType(int n) {
        this.unionType = n;
    }

    public int getUnionType() {
        return this.unionType;
    }

    public void setRight(Query query) {
        this.right = query;
    }

    public Query getLeft() {
        return this.left;
    }

    public Query getRight() {
        return this.right;
    }

    @Override
    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    @Override
    public void setOrder(ArrayList<SelectOrderBy> arrayList) {
        this.orderList = arrayList;
    }

    private Value[] convert(Value[] valueArray, int n) {
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions.get(i);
            valueArray[i] = valueArray[i].convertTo(expression.getType());
        }
        return valueArray;
    }

    @Override
    public ResultInterface queryMeta() {
        int n = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n);
        localResult.done();
        return localResult;
    }

    public LocalResult getEmptyResult() {
        int n = this.left.getColumnCount();
        return new LocalResult(this.session, this.expressionArray, n);
    }

    @Override
    protected LocalResult queryWithoutCache(int n) {
        if (n != 0) {
            if (this.limitExpr != null) {
                n = Math.min(this.limitExpr.getValue(this.session).getInt(), n);
            }
            this.limitExpr = ValueExpression.get(ValueInt.get(n));
        }
        int n2 = this.left.getColumnCount();
        LocalResult localResult = new LocalResult(this.session, this.expressionArray, n2);
        localResult.setSortOrder(this.sort);
        if (this.distinct) {
            this.left.setDistinct(true);
            this.right.setDistinct(true);
            localResult.setDistinct();
        }
        switch (this.unionType) {
            case 0: 
            case 2: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                localResult.setDistinct();
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.left.setDistinct(true);
                this.right.setDistinct(true);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        ResultInterface resultInterface = this.left.query(0);
        ResultInterface resultInterface2 = this.right.query(0);
        resultInterface.reset();
        resultInterface2.reset();
        switch (this.unionType) {
            case 0: 
            case 1: {
                while (resultInterface.next()) {
                    localResult.addRow(this.convert(resultInterface.currentRow(), n2));
                }
                while (resultInterface2.next()) {
                    localResult.addRow(this.convert(resultInterface2.currentRow(), n2));
                }
                break;
            }
            case 2: {
                while (resultInterface.next()) {
                    localResult.addRow(this.convert(resultInterface.currentRow(), n2));
                }
                while (resultInterface2.next()) {
                    localResult.removeDistinct(this.convert(resultInterface2.currentRow(), n2));
                }
                break;
            }
            case 3: {
                LocalResult localResult2 = new LocalResult(this.session, this.expressionArray, n2);
                localResult2.setDistinct();
                while (resultInterface.next()) {
                    localResult2.addRow(this.convert(resultInterface.currentRow(), n2));
                }
                while (resultInterface2.next()) {
                    Value[] valueArray = this.convert(resultInterface2.currentRow(), n2);
                    if (!localResult2.containsDistinct(valueArray)) continue;
                    localResult.addRow(valueArray);
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        if (this.offsetExpr != null) {
            localResult.setOffset(this.offsetExpr.getValue(this.session).getInt());
        }
        if (this.limitExpr != null) {
            localResult.setLimit(this.limitExpr.getValue(this.session).getInt());
        }
        localResult.done();
        return localResult;
    }

    @Override
    public void init() {
        if (SysProperties.CHECK && this.checkInit) {
            DbException.throwInternalError();
        }
        this.checkInit = true;
        this.left.init();
        this.right.init();
        int n = this.left.getColumnCount();
        if (n != this.right.getColumnCount()) {
            throw DbException.get(21002);
        }
        ArrayList<Expression> arrayList = this.left.getExpressions();
        this.expressions = New.arrayList();
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            this.expressions.add(expression);
        }
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (SysProperties.CHECK && !this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        this.isPrepared = true;
        this.left.prepare();
        this.right.prepare();
        int n = this.left.getColumnCount();
        this.expressions = New.arrayList();
        ArrayList<Expression> arrayList = this.left.getExpressions();
        ArrayList<Expression> arrayList2 = this.right.getExpressions();
        for (int i = 0; i < n; ++i) {
            Expression expression = arrayList.get(i);
            Expression expression2 = arrayList2.get(i);
            int n2 = Value.getHigherOrder(expression.getType(), expression2.getType());
            long l = Math.max(expression.getPrecision(), expression2.getPrecision());
            int n3 = Math.max(expression.getScale(), expression2.getScale());
            int n4 = Math.max(expression.getDisplaySize(), expression2.getDisplaySize());
            Column column = new Column(expression.getAlias(), n2, l, n3, n4);
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), column);
            this.expressions.add(expressionColumn);
        }
        if (this.orderList != null) {
            this.initOrder(this.expressions, null, this.orderList, this.getColumnCount(), true);
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        this.expressionArray = new Expression[this.expressions.size()];
        this.expressions.toArray(this.expressionArray);
    }

    @Override
    public double getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> hashSet = this.left.getTables();
        hashSet.addAll(this.right.getTables());
        return hashSet;
    }

    @Override
    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    @Override
    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void setForUpdate(boolean bl) {
        this.left.setForUpdate(bl);
        this.right.setForUpdate(bl);
        this.isForUpdate = bl;
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.right.mapColumns(columnResolver, n);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public void addGlobalCondition(Parameter parameter, int n, int n2) {
        this.addParameter(parameter);
        switch (this.unionType) {
            case 0: 
            case 1: 
            case 3: {
                this.left.addGlobalCondition(parameter, n, n2);
                this.right.addGlobalCondition(parameter, n, n2);
                break;
            }
            case 2: {
                this.left.addGlobalCondition(parameter, n, n2);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getPlanSQL()).append(')');
        switch (this.unionType) {
            case 1: {
                stringBuilder.append(" UNION ALL ");
                break;
            }
            case 0: {
                stringBuilder.append(" UNION ");
                break;
            }
            case 3: {
                stringBuilder.append(" INTERSECT ");
                break;
            }
            case 2: {
                stringBuilder.append(" EXCEPT ");
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.unionType);
            }
        }
        stringBuilder.append('(').append(this.right.getPlanSQL()).append(')');
        Expression[] expressionArray = this.expressions.toArray(new Expression[this.expressions.size()]);
        if (this.sort != null) {
            stringBuilder.append(" ORDER BY ").append(this.sort.getSQL(expressionArray, expressionArray.length));
        }
        if (this.limitExpr != null) {
            stringBuilder.append(" LIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
            if (this.offsetExpr != null) {
                stringBuilder.append(" OFFSET ").append(StringUtils.unEnclose(this.offsetExpr.getSQL()));
            }
        }
        if (this.isForUpdate) {
            stringBuilder.append(" FOR UPDATE");
        }
        return stringBuilder.toString();
    }

    @Override
    public ResultInterface query(int n) {
        return this.queryWithoutCache(n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public boolean isReadOnly() {
        return this.left.isReadOnly() && this.right.isReadOnly();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    @Override
    public void fireBeforeSelectTriggers() {
        this.left.fireBeforeSelectTriggers();
        this.right.fireBeforeSelectTriggers();
    }
}

