/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.ConditionIn;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Comparison
extends Condition {
    public static final int NULL_SAFE = 16;
    public static final int EQUAL = 0;
    public static final int EQUAL_NULL_SAFE = 16;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int NOT_EQUAL_NULL_SAFE = 21;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    public static final int IN_LIST = 9;
    public static final int IN_QUERY = 10;
    private final Database database;
    private int compareType;
    private Expression left;
    private Expression right;

    public Comparison(Session session, int n, Expression expression, Expression expression2) {
        this.database = session.getDatabase();
        this.left = expression;
        this.right = expression2;
        this.compareType = n;
    }

    @Override
    public String getSQL() {
        String string;
        switch (this.compareType) {
            case 0: {
                string = this.left.getSQL() + " = " + this.right.getSQL();
                break;
            }
            case 16: {
                string = this.left.getSQL() + " IS " + this.right.getSQL();
                break;
            }
            case 1: {
                string = this.left.getSQL() + " >= " + this.right.getSQL();
                break;
            }
            case 2: {
                string = this.left.getSQL() + " > " + this.right.getSQL();
                break;
            }
            case 3: {
                string = this.left.getSQL() + " <= " + this.right.getSQL();
                break;
            }
            case 4: {
                string = this.left.getSQL() + " < " + this.right.getSQL();
                break;
            }
            case 5: {
                string = this.left.getSQL() + " <> " + this.right.getSQL();
                break;
            }
            case 21: {
                string = this.left.getSQL() + " IS NOT " + this.right.getSQL();
                break;
            }
            case 6: {
                string = this.left.getSQL() + " IS NULL";
                break;
            }
            case 7: {
                string = this.left.getSQL() + " IS NOT NULL";
                break;
            }
            default: {
                throw DbException.throwInternalError("compareType=" + this.compareType);
            }
        }
        return "(" + string + ")";
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            Object object;
            this.right = this.right.optimize(session);
            if (this.right instanceof ExpressionColumn && (this.left.isConstant() || this.left instanceof Parameter)) {
                object = this.left;
                this.left = this.right;
                this.right = object;
                this.compareType = this.getReversedCompareType(this.compareType);
            }
            if (this.left instanceof ExpressionColumn) {
                if (this.right.isConstant()) {
                    object = this.right.getValue(session);
                    if (object == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
                        return ValueExpression.getNull();
                    }
                } else if (this.right instanceof Parameter) {
                    ((Parameter)this.right).setColumn(((ExpressionColumn)this.left).getColumn());
                }
            }
        }
        if (this.compareType == 6 || this.compareType == 7) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (SysProperties.CHECK && (this.left == null || this.right == null)) {
                DbException.throwInternalError();
            }
            if ((this.left == ValueExpression.getNull() || this.right == ValueExpression.getNull()) && (this.compareType & 0x10) == 0) {
                return ValueExpression.getNull();
            }
            if (this.left.isConstant() && this.right.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (this.right == null) {
            boolean bl;
            switch (this.compareType) {
                case 6: {
                    bl = value == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    bl = value != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + this.compareType);
                }
            }
            return ValueBoolean.get(bl);
        }
        if (value == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        Value value2 = this.right.getValue(session);
        if (value2 == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(this.left.getType(), this.right.getType());
        value = value.convertTo(n);
        value2 = value2.convertTo(n);
        boolean bl = Comparison.compareNotNull(this.database, value, value2, this.compareType);
        return ValueBoolean.get(bl);
    }

    static boolean compareNotNull(Database database, Value value, Value value2, int n) {
        boolean bl;
        switch (n) {
            case 0: 
            case 16: {
                bl = database.areEqual(value, value2);
                break;
            }
            case 5: 
            case 21: {
                bl = !database.areEqual(value, value2);
                break;
            }
            case 1: {
                bl = database.compare(value, value2) >= 0;
                break;
            }
            case 2: {
                bl = database.compare(value, value2) > 0;
                break;
            }
            case 3: {
                bl = database.compare(value, value2) <= 0;
                break;
            }
            case 4: {
                bl = database.compare(value, value2) < 0;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return bl;
    }

    private int getReversedCompareType(int n) {
        switch (this.compareType) {
            case 0: 
            case 5: 
            case 16: 
            case 21: {
                return n;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    private int getNotCompareType() {
        switch (this.compareType) {
            case 0: {
                return 5;
            }
            case 16: {
                return 21;
            }
            case 5: {
                return 0;
            }
            case 21: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        int n = this.getNotCompareType();
        return new Comparison(session, n, this.left, this.right);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        ExpressionVisitor expressionVisitor;
        ExpressionColumn expressionColumn = null;
        if (this.left instanceof ExpressionColumn && tableFilter != (expressionColumn = (ExpressionColumn)this.left).getTableFilter()) {
            expressionColumn = null;
        }
        if (this.right == null) {
            if (expressionColumn != null) {
                switch (this.compareType) {
                    case 6: {
                        if (!SysProperties.OPTIMIZE_IS_NULL) break;
                        tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, ValueExpression.getNull()));
                    }
                }
            }
            return;
        }
        ExpressionColumn expressionColumn2 = null;
        if (this.right instanceof ExpressionColumn && tableFilter != (expressionColumn2 = (ExpressionColumn)this.right).getTableFilter()) {
            expressionColumn2 = null;
        }
        if (expressionColumn == null && expressionColumn2 == null) {
            return;
        }
        if (expressionColumn != null && expressionColumn2 != null) {
            return;
        }
        if (expressionColumn == null) {
            expressionVisitor = ExpressionVisitor.get(6);
            expressionVisitor.setResolver(tableFilter);
            if (!this.left.isEverything(expressionVisitor)) {
                return;
            }
        } else if (expressionColumn2 == null) {
            expressionVisitor = ExpressionVisitor.get(6);
            expressionVisitor.setResolver(tableFilter);
            if (!this.right.isEverything(expressionVisitor)) {
                return;
            }
        } else {
            return;
        }
        switch (this.compareType) {
            case 5: 
            case 21: {
                bl = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                bl = true;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (bl) {
            if (expressionColumn != null) {
                tableFilter.addIndexCondition(IndexCondition.get(this.compareType, expressionColumn, this.right));
            } else if (expressionColumn2 != null) {
                int n = this.getReversedCompareType(this.compareType);
                tableFilter.addIndexCondition(IndexCondition.get(n, expressionColumn2, this.left));
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.compareType == 6 && bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && (this.right == null || this.right.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + (this.right == null ? 0 : this.right.getCost()) + 1;
    }

    Expression getIfEquals(Expression expression) {
        if (this.compareType == 0) {
            String string = expression.getSQL();
            if (this.left.getSQL().equals(string)) {
                return this.right;
            }
            if (this.right.getSQL().equals(string)) {
                return this.left;
            }
        }
        return null;
    }

    Expression getAdditional(Session session, Comparison comparison, boolean bl) {
        if (this.compareType == comparison.compareType && this.compareType == 0) {
            boolean bl2 = this.left.isConstant();
            boolean bl3 = this.right.isConstant();
            boolean bl4 = comparison.left.isConstant();
            boolean bl5 = comparison.right.isConstant();
            String string = this.left.getSQL();
            String string2 = comparison.left.getSQL();
            String string3 = this.right.getSQL();
            String string4 = comparison.right.getSQL();
            if (bl) {
                if (!(bl3 && bl5 || !string.equals(string2))) {
                    return new Comparison(session, 0, this.right, comparison.right);
                }
                if (!(bl3 && bl4 || !string.equals(string4))) {
                    return new Comparison(session, 0, this.right, comparison.left);
                }
                if (!(bl2 && bl5 || !string3.equals(string2))) {
                    return new Comparison(session, 0, this.left, comparison.right);
                }
                if (!(bl2 && bl4 || !string3.equals(string4))) {
                    return new Comparison(session, 0, this.left, comparison.left);
                }
            } else {
                Database database = session.getDatabase();
                if (bl3 && bl5 && string.equals(string2)) {
                    return new ConditionIn(database, this.left, New.arrayList(Arrays.asList(this.right, comparison.right)));
                }
                if (bl3 && bl4 && string.equals(string4)) {
                    return new ConditionIn(database, this.left, New.arrayList(Arrays.asList(this.right, comparison.left)));
                }
                if (bl2 && bl5 && string3.equals(string2)) {
                    return new ConditionIn(database, this.right, New.arrayList(Arrays.asList(this.left, comparison.right)));
                }
                if (bl2 && bl4 && string3.equals(string4)) {
                    return new ConditionIn(database, this.right, New.arrayList(Arrays.asList(this.left, comparison.left)));
                }
            }
        }
        return null;
    }

    public Expression getExpression(boolean bl) {
        return bl ? this.left : this.right;
    }
}

