/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.util.ArrayList;
import org.h2.jaqu.Db;
import org.h2.jaqu.Query;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.TableDefinition;
import org.h2.jaqu.Token;
import org.h2.jaqu.util.ClassUtils;
import org.h2.jaqu.util.Utils;

class SelectTable<T> {
    private static int asCounter;
    private Query<T> query;
    private Class<T> clazz;
    private T current;
    private String as;
    private TableDefinition<T> aliasDef;
    private boolean outerJoin;
    private ArrayList<Token> joinConditions = Utils.newArrayList();
    private T alias;

    SelectTable(Db db, Query<T> query, T t, boolean bl) {
        this.alias = t;
        this.query = query;
        this.outerJoin = bl;
        this.aliasDef = db.getTableDefinition(t.getClass());
        this.clazz = ClassUtils.getClass(t);
        this.as = "T" + asCounter++;
    }

    T getAlias() {
        return this.alias;
    }

    T newObject() {
        return Utils.newObject(this.clazz);
    }

    TableDefinition<T> getAliasDefinition() {
        return this.aliasDef;
    }

    void appendSQL(SQLStatement sQLStatement) {
        if (this.query.isJoin()) {
            sQLStatement.appendSQL(this.aliasDef.tableName + " AS " + this.as);
        } else {
            sQLStatement.appendSQL(this.aliasDef.tableName);
        }
    }

    void appendSQLAsJoin(SQLStatement sQLStatement, Query<T> query) {
        if (this.outerJoin) {
            sQLStatement.appendSQL(" LEFT OUTER JOIN ");
        } else {
            sQLStatement.appendSQL(" INNER JOIN ");
        }
        this.appendSQL(sQLStatement);
        if (!this.joinConditions.isEmpty()) {
            sQLStatement.appendSQL(" ON ");
            for (Token token : this.joinConditions) {
                token.appendSQL(sQLStatement, query);
                sQLStatement.appendSQL(" ");
            }
        }
    }

    boolean getOuterJoin() {
        return this.outerJoin;
    }

    Query<T> getQuery() {
        return this.query;
    }

    String getAs() {
        return this.as;
    }

    void addConditionToken(Token token) {
        this.joinConditions.add(token);
    }

    T getCurrent() {
        return this.current;
    }

    void setCurrent(T t) {
        this.current = t;
    }
}

