/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.h2.jaqu.Token;
import org.h2.jaqu.bytecode.And;
import org.h2.jaqu.bytecode.ArrayGet;
import org.h2.jaqu.bytecode.CaseWhen;
import org.h2.jaqu.bytecode.Constant;
import org.h2.jaqu.bytecode.ConstantNumber;
import org.h2.jaqu.bytecode.ConstantString;
import org.h2.jaqu.bytecode.Function;
import org.h2.jaqu.bytecode.Not;
import org.h2.jaqu.bytecode.Null;
import org.h2.jaqu.bytecode.Operation;
import org.h2.jaqu.bytecode.Or;
import org.h2.jaqu.bytecode.Variable;

public class ClassReader {
    private static final boolean DEBUG = false;
    private byte[] data;
    private int pos;
    private Constant[] constantPool;
    private int startByteCode;
    private String methodName;
    private String convertMethodName;
    private Token result;
    private Stack<Token> stack = new Stack();
    private ArrayList<Token> variables = new ArrayList();
    private boolean endOfMethod;
    private boolean condition;
    private int nextPc;
    private Map<String, Object> fieldMap = new HashMap<String, Object>();

    private void debug(String string) {
    }

    public Token decompile(Object object, Map<String, Object> map, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.fieldMap = map;
        this.convertMethodName = string;
        Class<?> clazz = object.getClass();
        String string2 = clazz.getName();
        this.debug("class name " + string2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            InputStream inputStream = clazz.getClassLoader().getResource(string2.replace('.', '/') + ".class").openStream();
            while ((n5 = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n5);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not read class bytecode", iOException);
        }
        this.data = byteArrayOutputStream.toByteArray();
        int n6 = this.readInt();
        this.debug("header: " + Integer.toHexString(n6));
        n5 = this.readShort();
        int n7 = this.readShort();
        this.debug("version: " + n7 + "." + n5);
        int n8 = this.readShort();
        this.constantPool = new Constant[n8];
        block16: for (n4 = 1; n4 < n8; ++n4) {
            n3 = this.readByte();
            switch (n3) {
                case 1: {
                    this.constantPool[n4] = ConstantString.get(this.readString());
                    continue block16;
                }
                case 3: {
                    int n9 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get(n9);
                    continue block16;
                }
                case 4: {
                    int n10 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get("" + Float.intBitsToFloat(n10), n10, Constant.Type.FLOAT);
                    continue block16;
                }
                case 5: {
                    long l = this.readLong();
                    this.constantPool[n4] = ConstantNumber.get(l);
                    ++n4;
                    continue block16;
                }
                case 6: {
                    long l = this.readLong();
                    this.constantPool[n4] = ConstantNumber.get("" + Double.longBitsToDouble(l), l, Constant.Type.DOUBLE);
                    ++n4;
                    continue block16;
                }
                case 7: {
                    int n11 = this.readShort();
                    this.constantPool[n4] = ConstantNumber.get(null, n11, Constant.Type.CLASS_REF);
                    continue block16;
                }
                case 8: {
                    int n12 = this.readShort();
                    this.constantPool[n4] = ConstantNumber.get(null, n12, Constant.Type.STRING_REF);
                    continue block16;
                }
                case 9: {
                    int n13 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get(null, n13, Constant.Type.FIELD_REF);
                    continue block16;
                }
                case 10: {
                    int n14 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get(null, n14, Constant.Type.METHOD_REF);
                    continue block16;
                }
                case 11: {
                    int n15 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get(null, n15, Constant.Type.INTERFACE_METHOD_REF);
                    continue block16;
                }
                case 12: {
                    int n16 = this.readInt();
                    this.constantPool[n4] = ConstantNumber.get(null, n16, Constant.Type.NAME_AND_TYPE);
                    continue block16;
                }
                default: {
                    throw new RuntimeException("Unsupported constant pool tag: " + n3);
                }
            }
        }
        n4 = this.readShort();
        this.debug("access flags: " + n4);
        n3 = this.readShort();
        this.debug("class: " + this.constantPool[this.constantPool[n3].intValue()]);
        int n17 = this.readShort();
        this.debug(" extends " + this.constantPool[this.constantPool[n17].intValue()]);
        int n18 = this.readShort();
        for (n2 = 0; n2 < n18; ++n2) {
            n = this.readShort();
            this.debug(" implements " + this.constantPool[this.constantPool[n].intValue()]);
        }
        n2 = this.readShort();
        for (n = 0; n < n2; ++n) {
            this.readField();
        }
        n = this.readShort();
        for (int i = 0; i < n; ++i) {
            this.readMethod();
        }
        this.readAttributes();
        return this.result;
    }

    private void readField() {
        int n = this.readShort();
        int n2 = this.readShort();
        int n3 = this.readShort();
        this.debug("    " + this.constantPool[n3] + " " + this.constantPool[n2] + " " + n);
        this.readAttributes();
    }

    private void readMethod() {
        int n = this.readShort();
        int n2 = this.readShort();
        int n3 = this.readShort();
        String string = this.constantPool[n3].toString();
        this.methodName = this.constantPool[n2].toString();
        this.debug("    " + string + " " + this.methodName + " " + n);
        this.readAttributes();
    }

    private void readAttributes() {
        int n = this.readShort();
        for (int i = 0; i < n; ++i) {
            int n2 = this.readShort();
            String string = this.constantPool[n2].toString();
            this.debug("        attribute " + string);
            int n3 = this.readInt();
            int n4 = this.pos + n3;
            if ("Code".equals(string)) {
                this.readCode();
            }
            this.pos = n4;
        }
    }

    void decompile() {
        int n = this.readShort();
        int n2 = this.readShort();
        this.debug("stack: " + n + " locals: " + n2);
        int n3 = this.readInt();
        this.startByteCode = this.pos;
        int n4 = this.pos + n3;
        while (this.pos < n4) {
            this.readByteCode();
        }
        this.debug("");
        this.pos = this.startByteCode + n3;
        int n5 = this.readShort();
        this.pos += 2 * n5;
        this.readAttributes();
    }

    private void readCode() {
        this.variables.clear();
        this.stack.clear();
        int n = this.readShort();
        int n2 = this.readShort();
        this.debug("stack: " + n + " locals: " + n2);
        int n3 = this.readInt();
        this.startByteCode = this.pos;
        if (this.methodName.startsWith(this.convertMethodName)) {
            this.result = this.getResult();
        }
        this.pos = this.startByteCode + n3;
        int n4 = this.readShort();
        this.pos += 2 * n4;
        this.readAttributes();
    }

    private Token getResult() {
        while (true) {
            this.readByteCode();
            if (this.endOfMethod) {
                return this.stack.pop();
            }
            if (this.condition) {
                Token token = this.stack.pop();
                Stack<Token> stack = new Stack<Token>();
                stack.addAll(this.stack);
                ArrayList<Token> arrayList = new ArrayList<Token>();
                arrayList.addAll(this.variables);
                int n = this.nextPc;
                Token token2 = this.getResult();
                this.stack = stack;
                this.variables = arrayList;
                this.pos = n + this.startByteCode;
                Token token3 = this.getResult();
                if (token2.equals("0") && token3.equals("1")) {
                    return token;
                }
                if (token2.equals("1") && token3.equals("0")) {
                    return Not.get(token);
                }
                if (token3.equals("0")) {
                    return And.get(Not.get(token), token2);
                }
                if (token2.equals("0")) {
                    return And.get(token, token3);
                }
                if (token3.equals("1")) {
                    return Or.get(token, token2);
                }
                if (token2.equals("1")) {
                    return And.get(Not.get(token), token3);
                }
                return CaseWhen.get(token, token3, token2);
            }
            if (this.nextPc == 0) continue;
            this.pos = this.nextPc + this.startByteCode;
        }
    }

    private void readByteCode() {
        String string;
        int n = this.pos - this.startByteCode;
        int n2 = this.readByte();
        this.endOfMethod = false;
        this.condition = false;
        this.nextPc = 0;
        switch (n2) {
            case 0: {
                string = "nop";
                break;
            }
            case 1: {
                string = "aconst_null";
                this.stack.push(Null.INSTANCE);
                break;
            }
            case 2: {
                string = "iconst_m1";
                this.stack.push(ConstantNumber.get("-1"));
                break;
            }
            case 3: {
                string = "iconst_0";
                this.stack.push(ConstantNumber.get("0"));
                break;
            }
            case 4: {
                string = "iconst_1";
                this.stack.push(ConstantNumber.get("1"));
                break;
            }
            case 5: {
                string = "iconst_2";
                this.stack.push(ConstantNumber.get("2"));
                break;
            }
            case 6: {
                string = "iconst_3";
                this.stack.push(ConstantNumber.get("3"));
                break;
            }
            case 7: {
                string = "iconst_4";
                this.stack.push(ConstantNumber.get("4"));
                break;
            }
            case 8: {
                string = "iconst_5";
                this.stack.push(ConstantNumber.get("5"));
                break;
            }
            case 9: {
                string = "lconst_0";
                this.stack.push(ConstantNumber.get("0"));
                break;
            }
            case 10: {
                string = "lconst_1";
                this.stack.push(ConstantNumber.get("1"));
                break;
            }
            case 11: {
                string = "fconst_0";
                this.stack.push(ConstantNumber.get("0.0"));
                break;
            }
            case 12: {
                string = "fconst_1";
                this.stack.push(ConstantNumber.get("1.0"));
                break;
            }
            case 13: {
                string = "fconst_2";
                this.stack.push(ConstantNumber.get("2.0"));
                break;
            }
            case 14: {
                string = "dconst_0";
                this.stack.push(ConstantNumber.get("0.0"));
                break;
            }
            case 15: {
                string = "dconst_1";
                this.stack.push(ConstantNumber.get("1.0"));
                break;
            }
            case 16: {
                byte by = (byte)this.readByte();
                string = "bipush " + by;
                this.stack.push(ConstantNumber.get(by));
                break;
            }
            case 17: {
                short s = (short)this.readShort();
                string = "sipush " + s;
                this.stack.push(ConstantNumber.get(s));
                break;
            }
            case 18: {
                Constant constant = this.getConstant(this.readByte());
                string = "ldc " + constant;
                this.stack.push(constant);
                break;
            }
            case 19: {
                Constant constant = this.getConstant(this.readShort());
                string = "ldc_w " + constant;
                this.stack.push(constant);
                break;
            }
            case 20: {
                Constant constant = this.getConstant(this.readShort());
                string = "ldc2_w " + constant;
                this.stack.push(constant);
                break;
            }
            case 21: {
                int n3 = this.readByte();
                string = "iload " + n3;
                this.stack.push(this.getVariable(n3));
                break;
            }
            case 22: {
                int n4 = this.readByte();
                string = "lload " + n4;
                this.stack.push(this.getVariable(n4));
                break;
            }
            case 23: {
                int n5 = this.readByte();
                string = "fload " + n5;
                this.stack.push(this.getVariable(n5));
                break;
            }
            case 24: {
                int n6 = this.readByte();
                string = "dload " + n6;
                this.stack.push(this.getVariable(n6));
                break;
            }
            case 25: {
                int n7 = this.readByte();
                string = "aload " + n7;
                this.stack.push(this.getVariable(n7));
                break;
            }
            case 26: {
                string = "iload_0";
                this.stack.push(this.getVariable(0));
                break;
            }
            case 27: {
                string = "iload_1";
                this.stack.push(this.getVariable(1));
                break;
            }
            case 28: {
                string = "iload_2";
                this.stack.push(this.getVariable(2));
                break;
            }
            case 29: {
                string = "iload_3";
                this.stack.push(this.getVariable(3));
                break;
            }
            case 30: {
                string = "lload_0";
                this.stack.push(this.getVariable(0));
                break;
            }
            case 31: {
                string = "lload_1";
                this.stack.push(this.getVariable(1));
                break;
            }
            case 32: {
                string = "lload_2";
                this.stack.push(this.getVariable(2));
                break;
            }
            case 33: {
                string = "lload_3";
                this.stack.push(this.getVariable(3));
                break;
            }
            case 34: {
                string = "fload_0";
                this.stack.push(this.getVariable(0));
                break;
            }
            case 35: {
                string = "fload_1";
                this.stack.push(this.getVariable(1));
                break;
            }
            case 36: {
                string = "fload_2";
                this.stack.push(this.getVariable(2));
                break;
            }
            case 37: {
                string = "fload_3";
                this.stack.push(this.getVariable(3));
                break;
            }
            case 38: {
                string = "dload_0";
                this.stack.push(this.getVariable(0));
                break;
            }
            case 39: {
                string = "dload_1";
                this.stack.push(this.getVariable(1));
                break;
            }
            case 40: {
                string = "dload_2";
                this.stack.push(this.getVariable(2));
                break;
            }
            case 41: {
                string = "dload_3";
                this.stack.push(this.getVariable(3));
                break;
            }
            case 42: {
                string = "aload_0";
                this.stack.push(this.getVariable(0));
                break;
            }
            case 43: {
                string = "aload_1";
                this.stack.push(this.getVariable(1));
                break;
            }
            case 44: {
                string = "aload_2";
                this.stack.push(this.getVariable(2));
                break;
            }
            case 45: {
                string = "aload_3";
                this.stack.push(this.getVariable(3));
                break;
            }
            case 46: {
                Token token = this.stack.pop();
                Token token2 = this.stack.pop();
                string = "iaload";
                this.stack.push(ArrayGet.get(token2, token));
                break;
            }
            case 47: {
                Token token = this.stack.pop();
                Token token3 = this.stack.pop();
                string = "laload";
                this.stack.push(ArrayGet.get(token3, token));
                break;
            }
            case 48: {
                Token token = this.stack.pop();
                Token token4 = this.stack.pop();
                string = "faload";
                this.stack.push(ArrayGet.get(token4, token));
                break;
            }
            case 49: {
                Token token = this.stack.pop();
                Token token5 = this.stack.pop();
                string = "daload";
                this.stack.push(ArrayGet.get(token5, token));
                break;
            }
            case 50: {
                Token token = this.stack.pop();
                Token token6 = this.stack.pop();
                string = "aaload";
                this.stack.push(ArrayGet.get(token6, token));
                break;
            }
            case 51: {
                Token token = this.stack.pop();
                Token token7 = this.stack.pop();
                string = "baload";
                this.stack.push(ArrayGet.get(token7, token));
                break;
            }
            case 52: {
                Token token = this.stack.pop();
                Token token8 = this.stack.pop();
                string = "caload";
                this.stack.push(ArrayGet.get(token8, token));
                break;
            }
            case 53: {
                Token token = this.stack.pop();
                Token token9 = this.stack.pop();
                string = "saload";
                this.stack.push(ArrayGet.get(token9, token));
                break;
            }
            case 54: {
                int n8 = this.readByte();
                string = "istore " + n8;
                this.setVariable(n8, this.stack.pop());
                break;
            }
            case 55: {
                int n9 = this.readByte();
                string = "lstore " + n9;
                this.setVariable(n9, this.stack.pop());
                break;
            }
            case 56: {
                int n10 = this.readByte();
                string = "fstore " + n10;
                this.setVariable(n10, this.stack.pop());
                break;
            }
            case 57: {
                int n11 = this.readByte();
                string = "dstore " + n11;
                this.setVariable(n11, this.stack.pop());
                break;
            }
            case 58: {
                int n12 = this.readByte();
                string = "astore " + n12;
                this.setVariable(n12, this.stack.pop());
                break;
            }
            case 59: {
                string = "istore_0";
                this.setVariable(0, this.stack.pop());
                break;
            }
            case 60: {
                string = "istore_1";
                this.setVariable(1, this.stack.pop());
                break;
            }
            case 61: {
                string = "istore_2";
                this.setVariable(2, this.stack.pop());
                break;
            }
            case 62: {
                string = "istore_3";
                this.setVariable(3, this.stack.pop());
                break;
            }
            case 63: {
                string = "lstore_0";
                this.setVariable(0, this.stack.pop());
                break;
            }
            case 64: {
                string = "lstore_1";
                this.setVariable(1, this.stack.pop());
                break;
            }
            case 65: {
                string = "lstore_2";
                this.setVariable(2, this.stack.pop());
                break;
            }
            case 66: {
                string = "lstore_3";
                this.setVariable(3, this.stack.pop());
                break;
            }
            case 67: {
                string = "fstore_0";
                this.setVariable(0, this.stack.pop());
                break;
            }
            case 68: {
                string = "fstore_1";
                this.setVariable(1, this.stack.pop());
                break;
            }
            case 69: {
                string = "fstore_2";
                this.setVariable(2, this.stack.pop());
                break;
            }
            case 70: {
                string = "fstore_3";
                this.setVariable(3, this.stack.pop());
                break;
            }
            case 71: {
                string = "dstore_0";
                this.setVariable(0, this.stack.pop());
                break;
            }
            case 72: {
                string = "dstore_1";
                this.setVariable(1, this.stack.pop());
                break;
            }
            case 73: {
                string = "dstore_2";
                this.setVariable(2, this.stack.pop());
                break;
            }
            case 74: {
                string = "dstore_3";
                this.setVariable(3, this.stack.pop());
                break;
            }
            case 75: {
                string = "astore_0";
                this.setVariable(0, this.stack.pop());
                break;
            }
            case 76: {
                string = "astore_1";
                this.setVariable(1, this.stack.pop());
                break;
            }
            case 77: {
                string = "astore_2";
                this.setVariable(2, this.stack.pop());
                break;
            }
            case 78: {
                string = "astore_3";
                this.setVariable(3, this.stack.pop());
                break;
            }
            case 79: {
                string = "iastore";
                break;
            }
            case 80: {
                string = "lastore";
                break;
            }
            case 81: {
                string = "fastore";
                break;
            }
            case 82: {
                string = "dastore";
                break;
            }
            case 83: {
                string = "aastore";
                break;
            }
            case 84: {
                string = "bastore";
                break;
            }
            case 85: {
                string = "castore";
                break;
            }
            case 86: {
                string = "sastore";
                break;
            }
            case 87: {
                string = "pop";
                this.stack.pop();
                break;
            }
            case 88: {
                string = "pop2";
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 89: {
                string = "dup";
                Token token = this.stack.pop();
                this.stack.push(token);
                this.stack.push(token);
                break;
            }
            case 90: {
                string = "dup_x1";
                Token token = this.stack.pop();
                Token token10 = this.stack.pop();
                this.stack.push(token);
                this.stack.push(token10);
                this.stack.push(token);
                break;
            }
            case 91: {
                string = "dup_x2";
                Token token = this.stack.pop();
                Token token11 = this.stack.pop();
                Token token12 = this.stack.pop();
                this.stack.push(token);
                this.stack.push(token12);
                this.stack.push(token11);
                this.stack.push(token);
                break;
            }
            case 92: {
                string = "dup2";
                Token token = this.stack.pop();
                Token token13 = this.stack.pop();
                this.stack.push(token13);
                this.stack.push(token);
                this.stack.push(token13);
                this.stack.push(token);
                break;
            }
            case 93: {
                string = "dup2_x1";
                Token token = this.stack.pop();
                Token token14 = this.stack.pop();
                Token token15 = this.stack.pop();
                this.stack.push(token14);
                this.stack.push(token);
                this.stack.push(token15);
                this.stack.push(token14);
                this.stack.push(token);
                break;
            }
            case 94: {
                string = "dup2_x2";
                Token token = this.stack.pop();
                Token token16 = this.stack.pop();
                Token token17 = this.stack.pop();
                Token token18 = this.stack.pop();
                this.stack.push(token16);
                this.stack.push(token);
                this.stack.push(token18);
                this.stack.push(token17);
                this.stack.push(token16);
                this.stack.push(token);
                break;
            }
            case 95: {
                string = "swap";
                Token token = this.stack.pop();
                Token token19 = this.stack.pop();
                this.stack.push(token);
                this.stack.push(token19);
                break;
            }
            case 96: {
                Token token = this.stack.pop();
                Token token20 = this.stack.pop();
                string = "iadd";
                this.stack.push(Operation.get(token20, Operation.Type.ADD, token));
                break;
            }
            case 97: {
                Token token = this.stack.pop();
                Token token21 = this.stack.pop();
                string = "ladd";
                this.stack.push(Operation.get(token21, Operation.Type.ADD, token));
                break;
            }
            case 98: {
                Token token = this.stack.pop();
                Token token22 = this.stack.pop();
                string = "fadd";
                this.stack.push(Operation.get(token22, Operation.Type.ADD, token));
                break;
            }
            case 99: {
                Token token = this.stack.pop();
                Token token23 = this.stack.pop();
                string = "dadd";
                this.stack.push(Operation.get(token23, Operation.Type.ADD, token));
                break;
            }
            case 100: {
                Token token = this.stack.pop();
                Token token24 = this.stack.pop();
                string = "isub";
                this.stack.push(Operation.get(token24, Operation.Type.SUBTRACT, token));
                break;
            }
            case 101: {
                Token token = this.stack.pop();
                Token token25 = this.stack.pop();
                string = "lsub";
                this.stack.push(Operation.get(token25, Operation.Type.SUBTRACT, token));
                break;
            }
            case 102: {
                Token token = this.stack.pop();
                Token token26 = this.stack.pop();
                string = "fsub";
                this.stack.push(Operation.get(token26, Operation.Type.SUBTRACT, token));
                break;
            }
            case 103: {
                Token token = this.stack.pop();
                Token token27 = this.stack.pop();
                string = "dsub";
                this.stack.push(Operation.get(token27, Operation.Type.SUBTRACT, token));
                break;
            }
            case 104: {
                Token token = this.stack.pop();
                Token token28 = this.stack.pop();
                string = "imul";
                this.stack.push(Operation.get(token28, Operation.Type.MULTIPLY, token));
                break;
            }
            case 105: {
                Token token = this.stack.pop();
                Token token29 = this.stack.pop();
                string = "lmul";
                this.stack.push(Operation.get(token29, Operation.Type.MULTIPLY, token));
                break;
            }
            case 106: {
                Token token = this.stack.pop();
                Token token30 = this.stack.pop();
                string = "fmul";
                this.stack.push(Operation.get(token30, Operation.Type.MULTIPLY, token));
                break;
            }
            case 107: {
                Token token = this.stack.pop();
                Token token31 = this.stack.pop();
                string = "dmul";
                this.stack.push(Operation.get(token31, Operation.Type.MULTIPLY, token));
                break;
            }
            case 108: {
                Token token = this.stack.pop();
                Token token32 = this.stack.pop();
                string = "idiv";
                this.stack.push(Operation.get(token32, Operation.Type.DIVIDE, token));
                break;
            }
            case 109: {
                Token token = this.stack.pop();
                Token token33 = this.stack.pop();
                string = "ldiv";
                this.stack.push(Operation.get(token33, Operation.Type.DIVIDE, token));
                break;
            }
            case 110: {
                Token token = this.stack.pop();
                Token token34 = this.stack.pop();
                string = "fdiv";
                this.stack.push(Operation.get(token34, Operation.Type.DIVIDE, token));
                break;
            }
            case 111: {
                Token token = this.stack.pop();
                Token token35 = this.stack.pop();
                string = "ddiv";
                this.stack.push(Operation.get(token35, Operation.Type.DIVIDE, token));
                break;
            }
            case 112: {
                Token token = this.stack.pop();
                Token token36 = this.stack.pop();
                string = "irem";
                this.stack.push(Operation.get(token36, Operation.Type.MOD, token));
                break;
            }
            case 113: {
                Token token = this.stack.pop();
                Token token37 = this.stack.pop();
                string = "lrem";
                this.stack.push(Operation.get(token37, Operation.Type.MOD, token));
                break;
            }
            case 114: {
                Token token = this.stack.pop();
                Token token38 = this.stack.pop();
                string = "frem";
                this.stack.push(Operation.get(token38, Operation.Type.MOD, token));
                break;
            }
            case 115: {
                Token token = this.stack.pop();
                Token token39 = this.stack.pop();
                string = "drem";
                this.stack.push(Operation.get(token39, Operation.Type.MOD, token));
                break;
            }
            case 148: {
                Token token = this.stack.pop();
                Token token40 = this.stack.pop();
                this.stack.push(new Function("SIGN", Operation.get(token40, Operation.Type.SUBTRACT, token)));
                string = "lcmp";
                break;
            }
            case 153: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.EQUALS, ConstantNumber.get(0)));
                string = "ifeq " + this.nextPc;
                break;
            }
            case 154: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.NOT_EQUALS, ConstantNumber.get(0)));
                string = "ifne " + this.nextPc;
                break;
            }
            case 155: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.SMALLER, ConstantNumber.get(0)));
                string = "iflt " + this.nextPc;
                break;
            }
            case 156: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.BIGGER_EQUALS, ConstantNumber.get(0)));
                string = "ifge " + this.nextPc;
                break;
            }
            case 157: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.BIGGER, ConstantNumber.get(0)));
                string = "ifgt " + this.nextPc;
                break;
            }
            case 158: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                this.stack.push(Operation.get(this.stack.pop(), Operation.Type.SMALLER_EQUALS, ConstantNumber.get(0)));
                string = "ifle " + this.nextPc;
                break;
            }
            case 159: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token41 = this.stack.pop();
                this.stack.push(Operation.get(token41, Operation.Type.EQUALS, token));
                string = "if_icmpeq " + this.nextPc;
                break;
            }
            case 160: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token42 = this.stack.pop();
                this.stack.push(Operation.get(token42, Operation.Type.NOT_EQUALS, token));
                string = "if_icmpne " + this.nextPc;
                break;
            }
            case 161: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token43 = this.stack.pop();
                this.stack.push(Operation.get(token43, Operation.Type.SMALLER, token));
                string = "if_icmplt " + this.nextPc;
                break;
            }
            case 162: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token44 = this.stack.pop();
                this.stack.push(Operation.get(token44, Operation.Type.BIGGER_EQUALS, token));
                string = "if_icmpge " + this.nextPc;
                break;
            }
            case 163: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token45 = this.stack.pop();
                this.stack.push(Operation.get(token45, Operation.Type.BIGGER, token));
                string = "if_icmpgt " + this.nextPc;
                break;
            }
            case 164: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token46 = this.stack.pop();
                this.stack.push(Operation.get(token46, Operation.Type.SMALLER_EQUALS, token));
                string = "if_icmple " + this.nextPc;
                break;
            }
            case 165: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token47 = this.stack.pop();
                this.stack.push(Operation.get(token47, Operation.Type.EQUALS, token));
                string = "if_acmpeq " + this.nextPc;
                break;
            }
            case 166: {
                this.condition = true;
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                Token token = this.stack.pop();
                Token token48 = this.stack.pop();
                this.stack.push(Operation.get(token48, Operation.Type.NOT_EQUALS, token));
                string = "if_acmpne " + this.nextPc;
                break;
            }
            case 167: {
                this.nextPc = this.getAbsolutePos(this.pos, this.readShort());
                string = "goto " + this.nextPc;
                break;
            }
            case 172: {
                string = "ireturn";
                this.endOfMethod = true;
                break;
            }
            case 173: {
                string = "lreturn";
                this.endOfMethod = true;
                break;
            }
            case 174: {
                string = "freturn";
                this.endOfMethod = true;
                break;
            }
            case 175: {
                string = "dreturn";
                this.endOfMethod = true;
                break;
            }
            case 176: {
                string = "areturn";
                this.endOfMethod = true;
                break;
            }
            case 177: {
                string = "return";
                this.stack.push(null);
                this.endOfMethod = true;
                break;
            }
            case 180: {
                String string2 = this.getField(this.readShort());
                Token token = this.stack.pop();
                String string3 = token + "." + string2.substring(string2.lastIndexOf(46) + 1, string2.indexOf(32));
                if (string3.startsWith("this.")) {
                    string3 = string3.substring(5);
                }
                this.stack.push(Variable.get(string3, this.fieldMap.get(string3)));
                string = "getfield " + string2;
                break;
            }
            case 182: {
                String string4 = this.getMethod(this.readShort());
                string = "invokevirtual " + string4;
                if (string4.equals("java/lang/String.equals (Ljava/lang/Object;)Z")) {
                    Token token = this.stack.pop();
                    Token token49 = this.stack.pop();
                    this.stack.push(Operation.get(token, Operation.Type.EQUALS, token49));
                    break;
                }
                if (string4.equals("java/lang/Integer.intValue ()I") || !string4.equals("java/lang/Long.longValue ()J")) break;
                break;
            }
            case 183: {
                String string5 = this.getMethod(this.readShort());
                string = "invokespecial " + string5;
                break;
            }
            case 184: {
                string = "invokestatic " + this.getMethod(this.readShort());
                break;
            }
            case 187: {
                String string6 = this.constantPool[this.constantPool[this.readShort()].intValue()].toString();
                string = "new " + string6;
                break;
            }
            case 200: {
                string = "goto_w " + this.getAbsolutePos(this.pos, this.readInt());
                break;
            }
            case 201: {
                string = "jsr_w " + this.getAbsolutePos(this.pos, this.readInt());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported opCode " + n2);
            }
        }
        this.debug("    " + n + ": " + string);
    }

    private void setVariable(int n, Token token) {
        while (n >= this.variables.size()) {
            this.variables.add(Variable.get("p" + this.variables.size(), null));
        }
        this.variables.set(n, token);
    }

    private Token getVariable(int n) {
        if (n == 0) {
            return Variable.THIS;
        }
        while (n >= this.variables.size()) {
            this.variables.add(Variable.get("p" + this.variables.size(), null));
        }
        return this.variables.get(n);
    }

    private String getField(int n) {
        int n2 = this.constantPool[n].intValue();
        int n3 = n2 >>> 16;
        int n4 = this.constantPool[n2 & 0xFFFF].intValue();
        String string = this.constantPool[this.constantPool[n3].intValue()] + "." + this.constantPool[n4 >>> 16] + " " + this.constantPool[n4 & 0xFFFF];
        return string;
    }

    private String getMethod(int n) {
        int n2 = this.constantPool[n].intValue();
        int n3 = n2 >>> 16;
        int n4 = this.constantPool[n2 & 0xFFFF].intValue();
        String string = this.constantPool[this.constantPool[n3].intValue()] + "." + this.constantPool[n4 >>> 16] + " " + this.constantPool[n4 & 0xFFFF];
        return string;
    }

    private Constant getConstant(int n) {
        Constant constant = this.constantPool[n];
        switch (constant.getType()) {
            case INT: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: {
                return constant;
            }
            case STRING_REF: {
                return this.constantPool[constant.intValue()];
            }
        }
        throw new RuntimeException("Not a constant: " + n);
    }

    private String readString() {
        int n = this.readShort();
        byte[] byArray = this.data;
        int n2 = this.pos;
        int n3 = n2 + n;
        char[] cArray = new char[n];
        int n4 = 0;
        while (n2 < n3) {
            int n5;
            cArray[n4] = (n5 = byArray[n2++] & 0xFF) < 128 ? (char)n5 : (n5 >= 224 ? (char)(((n5 & 0xF) << 12) + ((byArray[n2++] & 0x3F) << 6) + (byArray[n2++] & 0x3F)) : (char)(((n5 & 0x1F) << 6) + (byArray[n2++] & 0x3F)));
            ++n4;
        }
        this.pos = n2;
        return new String(cArray, 0, n4);
    }

    private int getAbsolutePos(int n, int n2) {
        return n - this.startByteCode - 1 + (short)n2;
    }

    private int readByte() {
        return this.data[this.pos++] & 0xFF;
    }

    private int readShort() {
        byte[] byArray = this.data;
        return ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    private int readInt() {
        byte[] byArray = this.data;
        return (byArray[this.pos++] << 24) + ((byArray[this.pos++] & 0xFF) << 16) + ((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF);
    }

    private long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }
}

