/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import org.h2.java.ClassObj;
import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class OpExpr
implements Expr {
    Expr left;
    String op;
    Expr right;
    private final JavaParser context;

    OpExpr(JavaParser javaParser) {
        this.context = javaParser;
    }

    public String toString() {
        if (this.left == null) {
            return this.op + this.right;
        }
        if (this.right == null) {
            return this.left + this.op;
        }
        if (this.op.equals(">>>")) {
            return "(((u" + this.left.getType() + ") " + this.left + ") >> " + this.right + ")";
        }
        if (this.op.equals("+") && (this.left.getType().isObject() || this.right.getType().isObject())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("java_lang_StringBuilder_toString(");
            stringBuilder.append("java_lang_StringBuilder_append(");
            stringBuilder.append("java_lang_StringBuilder_init_obj(");
            stringBuilder.append(this.convertToString(this.left));
            stringBuilder.append("), ");
            stringBuilder.append(this.convertToString(this.right));
            stringBuilder.append("))");
            return stringBuilder.toString();
        }
        return "(" + this.left + " " + this.op + " " + this.right + ")";
    }

    private String convertToString(Expr expr) {
        Type type = expr.getType();
        if (type.arrayLevel > 0) {
            return expr.toString() + ".toString()";
        }
        if (type.classObj.isPrimitive) {
            ClassObj classObj = this.context.getWrapper(type.classObj);
            return JavaParser.toC(classObj + ".toString") + "(" + expr.toString() + ")";
        }
        if (expr.getType().toString().equals("java_lang_String*")) {
            return expr.toString();
        }
        return expr.toString() + ".toString()";
    }

    @Override
    public Type getType() {
        if (this.left == null) {
            return this.right.getType();
        }
        if (this.right == null) {
            return this.left.getType();
        }
        if (this.op.equals("+") && (this.left.getType().isObject() || this.right.getType().isObject())) {
            Type type = new Type();
            type.classObj = this.context.getClassObj("java.lang.String");
            return type;
        }
        Type type = this.left.getType();
        Type type2 = this.right.getType();
        if (type.classObj.primitiveType < type2.classObj.primitiveType) {
            return type2;
        }
        return type;
    }
}

