/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import org.h2.java.Expr;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class StringExpr
implements Expr {
    String text;
    private final JavaParser context;
    private Type type;

    StringExpr(JavaParser javaParser) {
        this.context = javaParser;
    }

    public String toString() {
        return "STRING(\"" + StringExpr.javaEncode(this.text) + "\")";
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            this.type = new Type();
            this.type.classObj = this.context.getClassObj("java.lang.String");
        }
        return this.type;
    }

    static String javaEncode(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n = c & 0xFFFF;
                    if (n >= 32 && n < 128) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    stringBuilder.append(Integer.toHexString(0x10000 | n).substring(1));
                }
            }
        }
        return stringBuilder.toString();
    }
}

