/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import org.h2.java.Expr;
import org.h2.java.FieldObj;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class VariableExpr
implements Expr {
    Expr base;
    FieldObj field;
    String name;
    private final JavaParser context;

    VariableExpr(JavaParser javaParser) {
        this.context = javaParser;
    }

    public String toString() {
        this.init();
        StringBuilder stringBuilder = new StringBuilder();
        if ("length".equals(this.name) && this.base.getType().arrayLevel > 0) {
            stringBuilder.append("LENGTH(");
            stringBuilder.append(this.base.toString());
            stringBuilder.append(")");
        } else {
            if (this.base != null) {
                stringBuilder.append(this.base.toString()).append("->");
            }
            if (this.field != null) {
                if (this.field.isStatic) {
                    stringBuilder.append(JavaParser.toC(this.field.declaredClass + "." + this.field.name));
                } else {
                    stringBuilder.append(this.field.name);
                }
            } else {
                stringBuilder.append(JavaParser.toC(this.name));
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.field != null) return;
        Type type = this.base.getType();
        if (type.arrayLevel > 0) {
            if (!"length".equals(this.name)) throw new RuntimeException("Unknown array method: " + this.name);
            this.field = new FieldObj();
            this.field.type = this.context.getClassObj((String)"int").baseType;
            return;
        } else {
            this.field = type.classObj.getField(this.name);
        }
    }

    @Override
    public Type getType() {
        this.init();
        return this.field.type;
    }
}

