/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    private Value value;
    private JdbcConnection conn;

    public JdbcBlob(JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(jdbcConnection.getSession().getTrace(), 9, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        try {
            long l;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (l = this.value.getPrecision()) > 0L) {
                return l;
            }
            l = 0L;
            InputStream inputStream = this.value.getInputStream();
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray, 0, 4096)) > 0) {
                    l += (long)n;
                }
            }
            finally {
                inputStream.close();
            }
            return l;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        try {
            this.debugCode("getBytes(" + l + ", " + n + ");");
            this.checkClosed();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.value.getInputStream();
            try {
                IOUtils.skipFully(inputStream, l - 1L);
                while (n > 0) {
                    int n2 = inputStream.read();
                    if (n2 < 0) {
                        break;
                    }
                    byteArrayOutputStream.write(n2);
                    --n;
                }
            }
            finally {
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.debugCode("setBytes(" + l + ", bytes);");
        throw this.unsupported("LOB update");
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkClosed();
            return this.value.getInputStream();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        this.debugCode("position(pattern, " + l + ");");
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        this.debugCode("position(blobPattern, " + l + ");");
        throw this.unsupported("LOB subset");
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

