/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.server.pg.PgServer;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.ScriptReader;
import org.h2.util.Utils;

public class PgServerThread
implements Runnable {
    private PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO";
    private HashMap<String, Prepared> prepared = New.hashMap();
    private HashMap<String, Portal> portals = New.hashMap();

    PgServerThread(Socket socket, PgServer pgServer) {
        this.server = pgServer;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream inputStream = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(inputStream);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.dataIn.read()) > 0) {
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private int readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] byArray) throws IOException {
        this.dataIn.readFully(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int n;
        if (this.initDone) {
            n = this.dataInRaw.read();
            if (n < 0) {
                this.stop = true;
                return;
            }
        } else {
            n = 0;
        }
        int n2 = this.dataInRaw.readInt();
        byte[] byArray = Utils.newBytes(n2 -= 4);
        this.dataInRaw.readFully(byArray, 0, n2);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(byArray, 0, n2));
        switch (n) {
            case 0: {
                String string;
                this.server.trace("Init");
                int n3 = this.readInt();
                if (n3 == 80877102) {
                    this.server.trace("CancelRequest (not supported)");
                    this.server.trace(" pid: " + this.readInt());
                    this.server.trace(" key: " + this.readInt());
                    break;
                }
                if (n3 == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + n3 + " (" + (n3 >> 16) + "." + (n3 & 0xFF) + ")");
                while ((string = this.readString()).length() != 0) {
                    String string2 = this.readString();
                    if ("user".equals(string)) {
                        this.userName = string2;
                    } else if ("database".equals(string)) {
                        this.databaseName = string2;
                    } else if ("client_encoding".equals(string)) {
                        this.clientEncoding = string2;
                    } else if ("DateStyle".equals(string)) {
                        this.dateStyle = string2;
                    }
                    this.server.trace(" param " + string + "=" + string2);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                String string = this.readString();
                try {
                    Properties properties = new Properties();
                    properties.put("MODE", "PostgreSQL");
                    properties.put("USER", this.userName);
                    properties.put("PASSWORD", string);
                    String string3 = "jdbc:h2:" + this.databaseName;
                    ConnectionInfo connectionInfo = new ConnectionInfo(string3, properties);
                    String string4 = this.server.getBaseDir();
                    if (string4 == null) {
                        string4 = SysProperties.getBaseDir();
                    }
                    if (string4 != null) {
                        connectionInfo.setBaseDir(string4);
                    }
                    if (this.server.getIfExists()) {
                        connectionInfo.setProperty("IFEXISTS", "TRUE");
                    }
                    this.conn = new JdbcConnection(connectionInfo, false);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                Prepared prepared = new Prepared();
                prepared.name = this.readString();
                prepared.sql = this.getSQL(this.readString());
                int n4 = this.readShort();
                prepared.paramType = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    int n5 = this.readInt();
                    this.server.checkType(n5);
                    prepared.paramType[i] = n5;
                }
                try {
                    prepared.prep = this.conn.prepareStatement(prepared.sql);
                    this.prepared.put(prepared.name, prepared);
                    this.sendParseComplete();
                }
                catch (Exception exception) {
                    this.sendErrorResponse(exception);
                }
                break;
            }
            case 66: {
                int n6;
                int n7;
                int n8;
                this.server.trace("Bind");
                Portal portal = new Portal();
                portal.name = this.readString();
                String string = this.readString();
                Prepared prepared = this.prepared.get(string);
                if (prepared == null) {
                    this.sendErrorResponse("Portal not found");
                    break;
                }
                portal.sql = prepared.sql;
                portal.prep = prepared.prep;
                this.portals.put(portal.name, portal);
                int n9 = this.readShort();
                int[] nArray = new int[n9];
                for (n8 = 0; n8 < n9; ++n8) {
                    nArray[n8] = this.readShort();
                }
                n8 = this.readShort();
                for (n7 = 0; n7 < n8; ++n7) {
                    n6 = this.readInt();
                    byte[] byArray2 = Utils.newBytes(n6);
                    this.readFully(byArray2);
                    try {
                        this.setParameter(portal.prep, n7, byArray2, nArray);
                        continue;
                    }
                    catch (Exception exception) {
                        this.sendErrorResponse(exception);
                    }
                }
                n7 = this.readShort();
                portal.resultColumnFormat = new int[n7];
                for (n6 = 0; n6 < n7; ++n6) {
                    portal.resultColumnFormat[n6] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 68: {
                char c = (char)this.readByte();
                String string = this.readString();
                this.server.trace("Describe");
                if (c == 'S') {
                    Prepared prepared = this.prepared.get(string);
                    if (prepared == null) {
                        this.sendErrorResponse("Prepared not found: " + string);
                        break;
                    }
                    this.sendParameterDescription(prepared);
                    break;
                }
                if (c == 'P') {
                    Portal portal = this.portals.get(string);
                    if (portal == null) {
                        this.sendErrorResponse("Portal not found: " + string);
                        break;
                    }
                    PreparedStatement preparedStatement = portal.prep;
                    try {
                        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                        this.sendRowDescription(resultSetMetaData);
                    }
                    catch (Exception exception) {
                        this.sendErrorResponse(exception);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + c);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                String string = this.readString();
                this.server.trace("Execute");
                Portal portal = this.portals.get(string);
                if (portal == null) {
                    this.sendErrorResponse("Portal not found: " + string);
                    break;
                }
                int n10 = this.readShort();
                PreparedStatement preparedStatement = portal.prep;
                this.server.trace(portal.sql);
                try {
                    preparedStatement.setMaxRows(n10);
                    boolean bl = preparedStatement.execute();
                    if (bl) {
                        try {
                            ResultSet resultSet = preparedStatement.getResultSet();
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            this.sendRowDescription(resultSetMetaData);
                            while (resultSet.next()) {
                                this.sendDataRow(resultSet);
                            }
                            this.sendCommandComplete(portal.sql, 0);
                        }
                        catch (Exception exception) {
                            this.sendErrorResponse(exception);
                        }
                        break;
                    }
                    this.sendCommandComplete(portal.sql, preparedStatement.getUpdateCount());
                }
                catch (Exception exception) {
                    this.sendErrorResponse(exception);
                }
                break;
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.trace("Query");
                String string = this.readString();
                ScriptReader scriptReader = new ScriptReader(new StringReader(string));
                while (true) {
                    Statement statement = null;
                    try {
                        String string5 = scriptReader.readStatement();
                        if (string5 == null) break;
                        string5 = this.getSQL(string5);
                        statement = this.conn.createStatement();
                        boolean bl = statement.execute(string5);
                        if (bl) {
                            ResultSet resultSet = statement.getResultSet();
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            this.sendRowDescription(resultSetMetaData);
                            while (resultSet.next()) {
                                this.sendDataRow(resultSet);
                            }
                            this.sendCommandComplete(string5, 0);
                        } else {
                            this.sendCommandComplete(string5, statement.getUpdateCount());
                        }
                        JdbcUtils.closeSilently(statement);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.sendErrorResponse(sQLException);
                        continue;
                    }
                    finally {
                        JdbcUtils.closeSilently(statement);
                        continue;
                    }
                    break;
                }
                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + n + " (" + (char)n + ")");
            }
        }
    }

    private String getSQL(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("show max_identifier_length")) {
            string = "CALL 63";
        } else if (string2.startsWith("set client_encoding to")) {
            string = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(string + ";");
        }
        return string;
    }

    private void sendCommandComplete(String string, int n) throws IOException {
        String string2;
        this.startMessage(67);
        string = string.trim().toUpperCase();
        if (string.startsWith("INSERT")) {
            string2 = "INSERT 0 " + n;
        } else if (string.startsWith("DELETE")) {
            string2 = "DELETE " + n;
        } else if (string.startsWith("UPDATE")) {
            string2 = "UPDATE " + n;
        } else if (string.startsWith("SELECT") || string.startsWith("CALL")) {
            string2 = "SELECT";
        } else if (string.startsWith("BEGIN")) {
            string2 = "BEGIN";
        } else {
            this.server.trace("Check command tag: " + string);
            string2 = "UPDATE " + n;
        }
        this.writeString(string2);
        this.sendMessage();
    }

    private void sendDataRow(ResultSet resultSet) throws IOException {
        try {
            int n = resultSet.getMetaData().getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = resultSet.getString(i + 1);
            }
            this.startMessage(68);
            this.writeShort(n);
            for (String string : stringArray) {
                if (string == null) {
                    this.writeInt(-1);
                    continue;
                }
                byte[] byArray = string.getBytes(this.getEncoding());
                this.writeInt(byArray.length);
                this.write(byArray);
            }
            this.sendMessage();
        }
        catch (Exception exception) {
            this.sendErrorResponse(exception);
        }
    }

    private String getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return "UTF-8";
        }
        return this.clientEncoding;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, byte[] byArray, int[] nArray) throws SQLException {
        String string;
        boolean bl = n >= nArray.length || nArray[n] == 0;
        try {
            if (bl) {
                string = new String(byArray, this.getEncoding());
            } else {
                this.server.trace("Binary format not supported");
                string = new String(byArray, this.getEncoding());
            }
        }
        catch (Exception exception) {
            this.server.traceError(exception);
            string = null;
        }
        preparedStatement.setString(n + 1, string);
    }

    private void sendErrorResponse(Exception exception) throws IOException {
        SQLException sQLException = DbException.toSQLException(exception);
        this.server.traceError(sQLException);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(sQLException.getSQLState());
        this.write(77);
        this.writeString(sQLException.getMessage());
        this.write(68);
        this.writeString(sQLException.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(Prepared prepared) throws IOException {
        try {
            PreparedStatement preparedStatement = prepared.prep;
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            int n = parameterMetaData.getParameterCount();
            this.startMessage(116);
            this.writeShort(n);
            for (int i = 0; i < n; ++i) {
                int n2 = prepared.paramType != null && prepared.paramType[i] != 0 ? prepared.paramType[i] : 1043;
                this.server.checkType(n2);
                this.writeInt(n2);
            }
            this.sendMessage();
        }
        catch (Exception exception) {
            this.sendErrorResponse(exception);
        }
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData resultSetMetaData) throws IOException {
        try {
            if (resultSetMetaData == null) {
                this.sendNoData();
            } else {
                int n;
                int n2 = resultSetMetaData.getColumnCount();
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n2];
                String[] stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    String string;
                    stringArray[n] = string = resultSetMetaData.getColumnName(n + 1);
                    int n3 = resultSetMetaData.getColumnType(n + 1);
                    n3 = PgServer.convertType(n3);
                    nArray2[n] = resultSetMetaData.getColumnDisplaySize(n + 1);
                    this.server.checkType(n3);
                    nArray[n] = n3;
                }
                this.startMessage(84);
                this.writeShort(n2);
                for (n = 0; n < n2; ++n) {
                    this.writeString(stringArray[n].toLowerCase());
                    this.writeInt(0);
                    this.writeShort(0);
                    this.writeInt(nArray[n]);
                    this.writeShort(this.getTypeSize(nArray[n], nArray2[n]));
                    this.writeInt(-1);
                    this.writeShort(0);
                }
                this.sendMessage();
            }
        }
        catch (Exception exception) {
            this.sendErrorResponse(exception);
        }
    }

    private int getTypeSize(int n, int n2) {
        switch (n) {
            case 1043: {
                return Math.max(255, n2 + 10);
            }
        }
        return n2 + 4;
    }

    private void sendErrorResponse(String string) throws IOException {
        this.server.trace("Exception: " + string);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(string);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object = this.server;
            synchronized (object) {
                resultSet = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
                boolean bl = resultSet.next();
                statement = this.conn.createStatement();
                if (!bl) {
                    this.installPgCatalog(statement);
                }
                if (!(resultSet = statement.executeQuery("SELECT * FROM PG_CATALOG.PG_VERSION")).next() || resultSet.getInt(1) < 2) {
                    this.installPgCatalog(statement);
                } else {
                    int n = resultSet.getInt(2);
                    if (n > 2) {
                        throw DbException.throwInternalError("Incompatible PG_VERSION");
                    }
                }
            }
            statement.execute("set search_path = PUBLIC, pg_catalog");
            object = this.server.getTypeSet();
            if (((HashSet)object).size() == 0) {
                resultSet = statement.executeQuery("SELECT OID FROM PG_CATALOG.PG_TYPE");
                while (resultSet.next()) {
                    ((HashSet)object).add(resultSet.getInt(1));
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(resultSet);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(resultSet);
    }

    private void installPgCatalog(Statement statement) throws SQLException {
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(new ByteArrayInputStream(Utils.getResource("/org/h2/server/pg/pg_catalog.sql")));
            ScriptReader scriptReader = new ScriptReader(inputStreamReader);
            while ((string = scriptReader.readStatement()) != null) {
                statement.execute(string);
            }
            scriptReader.close();
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, "Can not read pg_catalog resource");
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStreamReader);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStreamReader);
    }

    void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int n;
        this.startMessage(90);
        try {
            n = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException sQLException) {
            n = 69;
        }
        this.write((byte)n);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.processId);
        this.sendMessage();
    }

    private void writeString(String string) throws IOException {
        this.write(string.getBytes(this.getEncoding()));
        this.write(0);
    }

    private void writeInt(int n) throws IOException {
        this.dataOut.writeInt(n);
    }

    private void writeShort(int n) throws IOException {
        this.dataOut.writeShort(n);
    }

    private void write(byte[] byArray) throws IOException {
        this.dataOut.write(byArray);
    }

    private void write(int n) throws IOException {
        this.dataOut.write(n);
    }

    private void startMessage(int n) {
        this.messageType = n;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] byArray = this.outBuffer.toByteArray();
        int n = byArray.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(n + 4);
        this.dataOut.write(byArray);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String string, String string2) throws IOException {
        this.startMessage(83);
        this.writeString(string);
        this.writeString(string2);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int n) {
        this.processId = n;
    }

    static class Portal {
        String name;
        String sql;
        int[] resultColumnFormat;
        PreparedStatement prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        PreparedStatement prep;
        int[] paramType;

        Prepared() {
        }
    }
}

