/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import org.h2.store.fs.FileObject;

public class FileObjectInputStream
extends InputStream {
    private FileObject file;
    private byte[] buffer = new byte[]{0};

    public FileObjectInputStream(FileObject fileObject) {
        this.file = fileObject;
    }

    @Override
    public int read() throws IOException {
        if (this.file.getFilePointer() >= this.file.length()) {
            return -1;
        }
        this.file.readFully(this.buffer, 0, 1);
        return this.buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.file.getFilePointer() + (long)n2 < this.file.length()) {
            this.file.readFully(byArray, n, n2);
            return n2;
        }
        return super.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

