/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDiskChannel;
import org.h2.store.fs.FileSystem;
import org.h2.store.fs.FileSystemDisk;

public class FileSystemDiskNio
extends FileSystemDisk {
    private static final String PREFIX = "nio:";

    @Override
    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        String string3 = super.createTempFile(string, string2, bl, bl2);
        return this.getPrefix() + string3;
    }

    @Override
    protected String translateFileName(String string) {
        if (string.startsWith(this.getPrefix())) {
            string = string.substring(this.getPrefix().length());
        }
        return super.translateFileName(string);
    }

    @Override
    public InputStream openFileInputStream(String string) throws IOException {
        return super.openFileInputStream(this.translateFileName(string));
    }

    @Override
    public String normalize(String string) {
        return this.getPrefix() + super.normalize(string);
    }

    @Override
    public String[] listFiles(String string) {
        String[] stringArray = super.listFiles(string);
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            stringArray[i] = this.getPrefix() + stringArray[i];
        }
        return stringArray;
    }

    @Override
    public String getParent(String string) {
        return this.getPrefix() + super.getParent(string);
    }

    @Override
    public String getAbsolutePath(String string) {
        return this.getPrefix() + super.getAbsolutePath(string);
    }

    @Override
    public FileObject openFileObject(String string, String string2) throws IOException {
        FileObject fileObject;
        string = this.translateFileName(string);
        try {
            fileObject = this.open(string, string2);
            this.trace("openRandomAccessFile", string, fileObject);
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                fileObject = this.open(string, string2);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
        return fileObject;
    }

    protected String getPrefix() {
        return PREFIX;
    }

    protected FileObject open(String string, String string2) throws IOException {
        return new FileObjectDiskChannel(string, string2);
    }

    @Override
    protected boolean accepts(String string) {
        return string.startsWith(this.getPrefix());
    }

    static {
        FileSystem.register(new FileSystemDiskNio());
    }
}

