/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<String> vector = new Vector<String>();
        for (Object object : this.keySet()) {
            vector.add(object.toString());
        }
        Collections.sort(vector);
        return new Vector(vector).elements();
    }

    public static boolean getBooleanProperty(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string, "" + bl);
        try {
            return Boolean.valueOf(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return bl;
        }
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, "" + n);
        try {
            return Integer.decode(string2);
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SortedProperties loadProperties(String string) throws IOException {
        SortedProperties sortedProperties = new SortedProperties();
        if (IOUtils.exists(string)) {
            InputStream inputStream = null;
            try {
                inputStream = IOUtils.openFileInputStream(string);
                sortedProperties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return sortedProperties;
    }

    public synchronized void store(String string) throws IOException {
        String string2;
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.store(byteArrayOutputStream, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "ISO8859-1");
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            outputStreamWriter = new OutputStreamWriter(IOUtils.openFileOutputStream(string, false));
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.startsWith("#")) continue;
            printWriter.print(string2 + "\n");
        }
        printWriter.close();
    }

    public synchronized String toLines() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : new TreeMap<Object, Object>(this).entrySet()) {
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public static SortedProperties fromLines(String string) {
        SortedProperties sortedProperties = new SortedProperties();
        for (String string2 : StringUtils.arraySplit(string, '\n', true)) {
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            sortedProperties.put(string2.substring(0, n), string2.substring(n + 1));
        }
        return sortedProperties;
    }
}

