/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import org.h2.message.DbException;
import org.h2.util.HashBase;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap<V>
extends HashBase {
    private Value[] keys;
    private V[] values;

    public static <T> ValueHashMap<T> newInstance() {
        return new ValueHashMap();
    }

    @Override
    protected void reset(int n) {
        super.reset(n);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    @Override
    protected void rehash(int n) {
        Value[] valueArray = this.keys;
        V[] VArray = this.values;
        this.reset(n);
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            if (value == null || value == ValueNull.DELETED) continue;
            this.put(value, VArray[i]);
        }
    }

    private int getIndex(Value value) {
        return value.hashCode() & this.mask;
    }

    public void put(Value value, V v) {
        this.checkSizePut();
        int n = this.getIndex(value);
        int n2 = 1;
        int n3 = -1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                if (n3 >= 0) {
                    n = n3;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n] = value;
                this.values[n] = v;
                return;
            }
            if (value2 == ValueNull.DELETED) {
                if (n3 < 0) {
                    n3 = n;
                }
            } else if (value2.equals(value)) {
                this.values[n] = v;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        DbException.throwInternalError("hashmap is full");
    }

    public void remove(Value value) {
        this.checkSizeRemove();
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return;
            }
            if (value2 != ValueNull.DELETED && value2.equals(value)) {
                this.keys[n] = ValueNull.DELETED;
                this.values[n] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
    }

    public V get(Value value) {
        int n = this.getIndex(value);
        int n2 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n]) == null) {
                return null;
            }
            if (value2 != ValueNull.DELETED && value2.equals(value)) {
                return this.values[n];
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        return null;
    }

    public ArrayList<Value> keys() {
        ArrayList<Value> arrayList = New.arrayList(this.size);
        for (Value value : this.keys) {
            if (value == null || value == ValueNull.DELETED) continue;
            arrayList.add(value);
        }
        return arrayList;
    }

    public ArrayList<V> values() {
        ArrayList arrayList = New.arrayList(this.size);
        for (int i = 0; i < this.keys.length; ++i) {
            Value value = this.keys[i];
            if (value == null || value == ValueNull.DELETED) continue;
            arrayList.add(this.values[i]);
        }
        return arrayList;
    }
}

