/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

public class ValueDate
extends Value {
    public static final int PRECISION = 8;
    static final int DISPLAY_SIZE = 10;
    private final Date value;

    private ValueDate(Date date) {
        this.value = date;
    }

    public static Date parseDate(String string) {
        return (Date)DateTimeUtils.parseDateTime(string, 10, 90009);
    }

    @Override
    public Date getDate() {
        return (Date)this.value.clone();
    }

    @Override
    public Date getDateNoCopy() {
        return this.value;
    }

    @Override
    public String getSQL() {
        return "DATE '" + this.getString() + "'";
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDate valueDate = (ValueDate)value;
        return Integer.signum(this.value.compareTo(valueDate.value));
    }

    @Override
    public String getString() {
        int n;
        String string = this.value.toString();
        long l = this.value.getTime();
        if (!(l >= ValueTimestamp.YEAR_ONE && l <= ValueTimestamp.YEAR_9999 || (n = DateTimeUtils.getDatePart(this.value, 1)) >= 1 && n <= 9999)) {
            string = n + string.substring(string.indexOf(45));
        }
        return string;
    }

    @Override
    public long getPrecision() {
        return 8L;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.getDate();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setDate(n, this.value);
    }

    public static ValueDate get(Date date) {
        date = DateTimeUtils.cloneAndNormalizeDate(date);
        return ValueDate.getNoCopy(date);
    }

    public static ValueDate getNoCopy(Date date) {
        return (ValueDate)Value.cache(new ValueDate(date));
    }

    @Override
    public int getDisplaySize() {
        return 10;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueDate && this.value.equals(((ValueDate)object).value);
    }
}

