/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int PRECISION = 6;
    static final int DISPLAY_SIZE = 8;
    private final Time value;

    private ValueTime(Time time) {
        this.value = time;
    }

    public static Time parseTime(String string) {
        return (Time)DateTimeUtils.parseDateTime(string, 9, 90010);
    }

    @Override
    public Time getTime() {
        return (Time)this.value.clone();
    }

    @Override
    public Time getTimeNoCopy() {
        return this.value;
    }

    @Override
    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTime valueTime = (ValueTime)value;
        return Integer.signum(this.value.compareTo(valueTime.value));
    }

    @Override
    public String getString() {
        return this.value.toString();
    }

    @Override
    public long getPrecision() {
        return 6L;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.getTime();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTime(n, this.value);
    }

    public static ValueTime get(Time time) {
        time = DateTimeUtils.cloneAndNormalizeTime(time);
        return ValueTime.getNoCopy(time);
    }

    public static ValueTime getNoCopy(Time time) {
        return (ValueTime)Value.cache(new ValueTime(time));
    }

    @Override
    public int getDisplaySize() {
        return 8;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueTime && this.value.equals(((ValueTime)object).value);
    }
}

