/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.h2.osgi.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.h2.osgi.utils.H2Constants;
import org.wso2.carbon.h2.osgi.utils.H2Utils;

public class CarbonUtils {
    public static String getCarbonXmlFilePath() {
        String carbonXmlPath = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "conf" + File.separator + "carbon.xml";
        try {
            new File(carbonXmlPath);
            return carbonXmlPath;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Map getH2Parameters() {
        HashMap h2Properties = new HashMap();
        H2Utils.resetToDefaultParameters(h2Properties);
        String carbonXmlFile = CarbonUtils.getCarbonXmlFilePath();
        try {
            File file = new File(carbonXmlFile);
            if (!file.exists()) {
                return h2Properties;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            Element rootEle = doc.getDocumentElement();
            NodeList childNodes2 = rootEle.getChildNodes();
            Node dbConfigurationNode = null;
            HashMap<String, String> h2PropertiesConfigured = new HashMap<String, String>();
            for (int i = 0; i < childNodes2.getLength(); ++i) {
                Node propertyEle = childNodes2.item(i);
                if (!propertyEle.getNodeName().equals("H2DatabaseConfiguration")) continue;
                dbConfigurationNode = propertyEle;
            }
            if (dbConfigurationNode == null) {
                return h2Properties;
            }
            NodeList childNodes = dbConfigurationNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                NamedNodeMap propertyAttribs;
                Node nameAttrib;
                Node propertyEle = childNodes.item(i);
                if (!propertyEle.getNodeName().equals("property") || (nameAttrib = (propertyAttribs = propertyEle.getAttributes()).getNamedItem("name")) == null) continue;
                String paraName = nameAttrib.getNodeValue();
                String value = propertyEle.getTextContent();
                if (!H2Constants.getParameterList().contains(paraName)) continue;
                if (value != null) {
                    value = value.replaceAll(Pattern.quote("${carbon.home}"), CarbonUtils.getCarbonHome());
                }
                h2PropertiesConfigured.put(paraName, value);
            }
            if (h2PropertiesConfigured.containsKey("web") || h2PropertiesConfigured.containsKey("tcp") || h2PropertiesConfigured.containsKey("pg")) {
                h2Properties = h2PropertiesConfigured;
            } else {
                for (String paraName : h2PropertiesConfigured.keySet()) {
                    h2Properties.put(paraName, h2PropertiesConfigured.get(paraName));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h2Properties;
    }

    public static String getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        return carbonHome;
    }
}

