/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.AMQTopic;
import org.wso2.andes.client.TemporaryDestination;
import org.wso2.andes.framing.AMQShortString;

class AMQTemporaryTopic
extends AMQTopic
implements TemporaryTopic,
TemporaryDestination {
    private final AMQSession _session;
    private boolean _deleted;

    public AMQTemporaryTopic(AMQSession session) {
        super(session.getTemporaryTopicExchangeName(), new AMQShortString("tmp_" + UUID.randomUUID()));
        this._session = session;
    }

    public void delete() throws JMSException {
        if (this._session.hasConsumer(this)) {
            throw new JMSException("Temporary Topic has consumers so cannot be deleted");
        }
        this._deleted = true;
    }

    public AMQSession getSession() {
        return this._session;
    }

    public boolean isDeleted() {
        return this._deleted;
    }
}

