/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.sasl.SaslClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.security.JCAProvider;
import org.wso2.andes.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSaslRegistrar {
    private static final Logger _logger = LoggerFactory.getLogger(DynamicSaslRegistrar.class);
    private static final String FILE_PROPERTY = "amq.dynamicsaslregistrar.properties";
    public static final String DEFAULT_RESOURCE_NAME = "org/wso2/andes/client/security/DynamicSaslRegistrar.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSaslProviders() {
        _logger.debug("public static void registerSaslProviders(): called");
        String filename = System.getProperty(FILE_PROPERTY);
        InputStream is = FileUtils.openFileOrDefaultResource(filename, DEFAULT_RESOURCE_NAME, DynamicSaslRegistrar.class.getClassLoader());
        try {
            Properties props = new Properties();
            props.load(is);
            _logger.debug("props = " + props);
            Map<String, Class<? extends SaslClientFactory>> factories = DynamicSaslRegistrar.parseProperties(props);
            if (factories.size() > 0) {
                if (Security.insertProviderAt(new JCAProvider(factories), 1) == -1) {
                    _logger.error("Unable to load custom SASL providers.");
                } else {
                    _logger.info("Additional SASL providers successfully registered.");
                }
            } else {
                _logger.warn("No additional SASL providers registered.");
            }
        }
        catch (IOException e) {
            _logger.error("Error reading properties: " + e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error("Unable to close properties stream: " + e, (Throwable)e);
                }
            }
        }
    }

    private static Map<String, Class<? extends SaslClientFactory>> parseProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        TreeMap<String, Class<? extends SaslClientFactory>> factoriesToRegister = new TreeMap<String, Class<? extends SaslClientFactory>>();
        while (e.hasMoreElements()) {
            String mechanism = (String)e.nextElement();
            String className = props.getProperty(mechanism);
            try {
                Class<?> clazz = Class.forName(className);
                if (!SaslClientFactory.class.isAssignableFrom(clazz)) {
                    _logger.error("Class " + clazz + " does not implement " + SaslClientFactory.class + " - skipping");
                    continue;
                }
                _logger.debug("Registering class " + clazz.getName() + " for mechanism " + mechanism);
                factoriesToRegister.put(mechanism, clazz);
            }
            catch (Exception ex) {
                _logger.error("Error instantiating SaslClientFactory calss " + className + " - skipping");
            }
        }
        return factoriesToRegister;
    }
}

