/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ExchangeDeclareBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class ExchangeDeclareBodyImpl
extends AMQMethodBody_0_9
implements ExchangeDeclareBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ExchangeDeclareBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _type;
    private final byte _bitfield0;
    private final FieldTable _arguments;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ExchangeDeclareBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._type = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._arguments = this.readFieldTable(buffer);
    }

    public ExchangeDeclareBodyImpl(int ticket, AMQShortString exchange, AMQShortString type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, FieldTable arguments) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._type = type;
        byte bitfield0 = 0;
        if (passive) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (durable) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (autoDelete) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        if (internal) {
            bitfield0 = (byte)(bitfield0 | 8);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 0x10);
        }
        this._bitfield0 = bitfield0;
        this._arguments = arguments;
    }

    public int getClazz() {
        return 40;
    }

    public int getMethod() {
        return 10;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getType() {
        return this._type;
    }

    public final boolean getPassive() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getDurable() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getAutoDelete() {
        return (this._bitfield0 & 4) != 0;
    }

    public final boolean getInternal() {
        return (this._bitfield0 & 8) != 0;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 0x10) != 0;
    }

    public final FieldTable getArguments() {
        return this._arguments;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._type);
        return size += this.getSizeOf(this._arguments);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._type);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._arguments);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchExchangeDeclare(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeclareBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("type=");
        buf.append(this.getType());
        buf.append(", ");
        buf.append("passive=");
        buf.append(this.getPassive());
        buf.append(", ");
        buf.append("durable=");
        buf.append(this.getDurable());
        buf.append(", ");
        buf.append("autoDelete=");
        buf.append(this.getAutoDelete());
        buf.append(", ");
        buf.append("internal=");
        buf.append(this.getInternal());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }
}

