/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.FileAckBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class FileAckBodyImpl
extends AMQMethodBody_8_0
implements FileAckBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileAckBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 90;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileAckBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public FileAckBodyImpl(long deliveryTag, boolean multiple) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (multiple) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 70;
    }

    public int getMethod() {
        return 90;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final boolean getMultiple() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 9;
        return size;
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFileAck(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[FileAckBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("multiple=");
        buf.append(this.getMultiple());
        buf.append("]");
        return buf.toString();
    }
}

