/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.messaging.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.andes.messaging.Address;
import org.wso2.andes.messaging.util.Lexer;
import org.wso2.andes.messaging.util.Lexicon;
import org.wso2.andes.messaging.util.ParseError;
import org.wso2.andes.messaging.util.Parser;
import org.wso2.andes.messaging.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressParser
extends Parser {
    private static Lexicon lxi = new Lexicon();
    private static Token.Type LBRACE = lxi.define("LBRACE", "\\{");
    private static Token.Type RBRACE = lxi.define("RBRACE", "\\}");
    private static Token.Type LBRACK = lxi.define("LBRACK", "\\[");
    private static Token.Type RBRACK = lxi.define("RBRACK", "\\]");
    private static Token.Type COLON = lxi.define("COLON", ":");
    private static Token.Type SEMI = lxi.define("SEMI", ";");
    private static Token.Type SLASH = lxi.define("SLASH", "/");
    private static Token.Type COMMA = lxi.define("COMMA", ",");
    private static Token.Type NUMBER = lxi.define("NUMBER", "[+-]?[0-9]*\\.?[0-9]+");
    private static Token.Type TRUE = lxi.define("TRUE", "True");
    private static Token.Type FALSE = lxi.define("FALSE", "False");
    private static Token.Type ID = lxi.define("ID", "[a-zA-Z_](?:[a-zA-Z0-9_-]*[a-zA-Z0-9_])?");
    private static Token.Type STRING = lxi.define("STRING", "\"(?:[^\\\"]|\\.)*\"|'(?:[^\\']|\\.)*'");
    private static Token.Type ESC = lxi.define("ESC", "\\\\[^ux]|\\\\x[0-9a-fA-F][0-9a-fA-F]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]");
    private static Token.Type SYM = lxi.define("SYM", "[.#*%@$^!+-]");
    private static Token.Type WSPACE = lxi.define("WSPACE", "[\\s]+");
    private static Token.Type EOF = lxi.eof("EOF");
    private static Lexer LEXER = lxi.compile();

    public static List<Token> lex(String input) {
        return LEXER.lex(input);
    }

    static List<Token> wlex(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Token t : AddressParser.lex(input)) {
            if (t.getType() == WSPACE) continue;
            tokens.add(t);
        }
        return tokens;
    }

    static String unquote(String st, Token tok) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < st.length() - 1; ++i) {
            char ch = st.charAt(i);
            if (ch == '\\') {
                char code = st.charAt(i + 1);
                switch (code) {
                    case '\n': {
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        break;
                    }
                    case 'a': {
                        result.append('\u0007');
                        break;
                    }
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'u': {
                        result.append(AddressParser.decode(st.substring(i + 2, i + 6)));
                        i += 4;
                        break;
                    }
                    case 'v': {
                        result.append('\u000b');
                        break;
                    }
                    case 'o': {
                        result.append(AddressParser.decode(st.substring(i + 2, i + 4), 8));
                        i += 2;
                        break;
                    }
                    case 'x': {
                        result.append(AddressParser.decode(st.substring(i + 2, i + 4)));
                        i += 2;
                        break;
                    }
                    default: {
                        throw new ParseError(tok, new Token.Type[0]);
                    }
                }
                ++i;
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    static char[] decode(String hex) {
        return AddressParser.decode(hex, 16);
    }

    static char[] decode(String code, int radix) {
        return Character.toChars(Integer.parseInt(code, radix));
    }

    static String tok2str(Token tok) {
        Token.Type type = tok.getType();
        String value = tok.getValue();
        if (type == STRING) {
            return AddressParser.unquote(value, tok);
        }
        if (type == ESC) {
            if (value.charAt(1) == 'x' || value.charAt(1) == 'u') {
                return new String(AddressParser.decode(value.substring(2)));
            }
            return value.substring(1);
        }
        return value;
    }

    static Object tok2obj(Token tok) {
        Token.Type type = tok.getType();
        String value = tok.getValue();
        if (type == STRING) {
            return AddressParser.unquote(value, tok);
        }
        if (type == NUMBER) {
            if (value.indexOf(46) >= 0) {
                return Double.valueOf(value);
            }
            return Integer.decode(value);
        }
        if (type == TRUE) {
            return true;
        }
        if (type == FALSE) {
            return false;
        }
        return value;
    }

    static String toks2str(List<Token> toks) {
        if (toks.size() > 0) {
            StringBuilder result = new StringBuilder();
            for (Token t : toks) {
                result.append(AddressParser.tok2str(t));
            }
            return result.toString();
        }
        return null;
    }

    public AddressParser(String input) {
        super(AddressParser.wlex(input));
    }

    public Address parse() {
        Address result = this.address();
        this.eat(EOF);
        return result;
    }

    public Address address() {
        Map<Object, Object> options;
        String subject;
        String name = AddressParser.toks2str(this.eat_until(SLASH, SEMI, EOF));
        if (name == null) {
            throw new ParseError(this.next(), new Token.Type[0]);
        }
        if (this.matches(SLASH)) {
            this.eat(SLASH);
            subject = AddressParser.toks2str(this.eat_until(SEMI, EOF));
        } else {
            subject = null;
        }
        if (this.matches(SEMI)) {
            this.eat(SEMI);
            options = this.map();
        } else {
            options = null;
        }
        return new Address(name, subject, options);
    }

    public Map<Object, Object> map() {
        HashMap<Object, Object> result;
        block4: {
            this.eat(LBRACE);
            result = new HashMap<Object, Object>();
            while (this.matches(NUMBER, STRING, ID, LBRACE, LBRACK)) {
                this.keyval(result);
                if (this.matches(COMMA)) {
                    this.eat(COMMA);
                    continue;
                }
                if (!this.matches(RBRACE)) {
                    throw new ParseError(this.next(), COMMA, RBRACE);
                }
                break block4;
            }
            if (!this.matches(RBRACE)) {
                throw new ParseError(this.next(), NUMBER, STRING, ID, LBRACE, LBRACK, RBRACE);
            }
        }
        this.eat(RBRACE);
        return result;
    }

    void keyval(Map<Object, Object> map) {
        Object key = this.value();
        this.eat(COLON);
        Object val = this.value();
        map.put(key, val);
    }

    Object value() {
        if (this.matches(NUMBER, STRING, ID, TRUE, FALSE)) {
            return AddressParser.tok2obj(this.eat(new Token.Type[0]));
        }
        if (this.matches(LBRACE)) {
            return this.map();
        }
        if (this.matches(LBRACK)) {
            return this.list();
        }
        throw new ParseError(this.next(), NUMBER, STRING, ID, LBRACE, LBRACK);
    }

    List<Object> list() {
        this.eat(LBRACK);
        ArrayList<Object> result = new ArrayList<Object>();
        while (!this.matches(RBRACK)) {
            result.add(this.value());
            if (this.matches(COMMA)) {
                this.eat(COMMA);
                continue;
            }
            if (this.matches(RBRACK)) break;
            throw new ParseError(this.next(), COMMA, RBRACK);
        }
        this.eat(RBRACK);
        return result;
    }
}

