/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndesExecuter {
    private static Log log = LogFactory.getLog(AndesExecuter.class);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static Map<String, PendingJob> pendingJobsTracker = new ConcurrentHashMap<String, PendingJob>();
    private static ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("AndesExecutor-%d").build();
    private static ExecutorService executorService = Executors.newFixedThreadPool(50, namedThreadFactory);
    private static ExecutorService genricExecutorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<?> submit(Runnable job, String channelId) {
        if (channelId != null) {
            Map<String, PendingJob> map = pendingJobsTracker;
            synchronized (map) {
                PendingJob pendingJob = pendingJobsTracker.get(channelId);
                if (pendingJob == null) {
                    pendingJob = new PendingJob();
                    pendingJobsTracker.put(channelId, pendingJob);
                }
                ++pendingJob.submittedJobs;
            }
        }
        return executorService.submit(new RunnableWrapper(job, channelId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait4JobsfromThisChannel2End(String channelId) {
        PendingJob pendingJobs;
        Map<String, PendingJob> map = pendingJobsTracker;
        synchronized (map) {
            pendingJobs = pendingJobsTracker.get(channelId);
        }
        if (pendingJobs != null) {
            try {
                pendingJobs.semaphore.tryAcquire(pendingJobs.submittedJobs, 1L, TimeUnit.SECONDS);
                if (isDebugEnabled) {
                    log.debug((Object)("All " + pendingJobs.submittedJobs + " completed for channel " + channelId));
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)("Closing Channnel " + channelId + "timedout waiting for submitted jobs to finish"));
            }
            finally {
                Map<String, PendingJob> map2 = pendingJobsTracker;
                synchronized (map2) {
                    pendingJobsTracker.remove(channelId);
                }
            }
        }
    }

    public static void runAsync(Runnable runnable) {
        genricExecutorService.submit(runnable);
    }

    static {
        if (isDebugEnabled) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                int workqueueSize = ((ThreadPoolExecutor)executorService).getQueue().size();
                                log.debug((Object)("AndesExecuter pool queue size " + workqueueSize));
                                Thread.sleep(30000L);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }
        genricExecutorService = Executors.newFixedThreadPool(8, namedThreadFactory);
    }

    public static class PendingJob {
        Semaphore semaphore = new Semaphore(0);
        int submittedJobs = 0;
    }

    public static class RunnableWrapper
    implements Runnable {
        Runnable runnable;
        String channelID;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                long timetook;
                long start = System.currentTimeMillis();
                this.runnable.run();
                if (isDebugEnabled && (timetook = System.currentTimeMillis() - start) > 20L) {
                    log.debug((Object)new StringBuffer().append("took ").append(this.runnable.getClass().getName()).append(" ").append(timetook));
                }
            }
            finally {
                if (this.channelID != null) {
                    Map map = pendingJobsTracker;
                    synchronized (map) {
                        ((PendingJob)pendingJobsTracker.get((Object)this.channelID)).semaphore.release();
                    }
                }
            }
        }

        public RunnableWrapper(Runnable runnable, String channelID) {
            this.runnable = runnable;
            this.channelID = channelID;
        }
    }
}

