/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.authenticator.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.authenticator.Authenticator;
import org.wso2.authenticator.AuthenticatorException;
import org.wso2.authenticator.help.UserHelpInfo;

public class JDBCAuthenticator
implements Authenticator {
    private static Log log = LogFactory.getLog(JDBCAuthenticator.class);
    protected Connection dbConnection = null;
    protected Driver driver = null;
    private String userCredentialColumn = null;
    private String userTable = null;
    private String userNameColumn = null;
    private String connectionUserName = null;
    private String connectionPassword = null;
    private String connectionURL = null;
    private String driverName = null;

    public boolean authenticate(String userName, Object credentials) throws AuthenticatorException {
        if (credentials == null) {
            return false;
        }
        if (userName == null) {
            return false;
        }
        boolean bValue = false;
        if (!(credentials instanceof String)) {
            throw new AuthenticatorException("Can handle only string type credentials");
        }
        try {
            String value;
            Statement stmt;
            ResultSet rs;
            this.open();
            String password = (String)credentials;
            String stmtValue = this.constructSQLtoReadPassword(userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)stmtValue);
            }
            if ((rs = (stmt = this.dbConnection.createStatement(1004, 1008)).executeQuery(stmtValue)).first() && (value = rs.getString(this.userCredentialColumn)) != null && value.equals(password)) {
                bValue = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthenticatorException("exceptionOnAuthenticate");
        }
        return bValue;
    }

    private String constructSQLtoReadPassword(String username) {
        StringBuffer sbuff = new StringBuffer("select ");
        sbuff.append(this.userCredentialColumn);
        sbuff.append(" from ");
        sbuff.append(this.userTable);
        sbuff.append(" where ");
        sbuff.append(this.userNameColumn);
        sbuff.append(" = '");
        sbuff.append(username);
        sbuff.append("'");
        return sbuff.toString();
    }

    public Connection open() throws AuthenticatorException, SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.connectionURL == null) {
            throw new AuthenticatorException("Connection URL is null");
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                log.debug((Object)e.getMessage(), e);
                e.printStackTrace();
                SQLException exc = new SQLException();
                if (exc.getNextException() != null) {
                    SQLException nextExecption = exc.getNextException();
                    log.debug((Object)"exceptionOnConnectionOpen", (Throwable)nextExecption);
                }
                throw new AuthenticatorException("exceptionOnConnectionOpen", e);
            }
        }
        Properties props = new Properties();
        if (this.connectionUserName != null) {
            props.put("user", this.connectionUserName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, props);
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    @UserHelpInfo(isRequired=true, getHelpText="Password column of user table", getInputType="text", getLabel="Password Column")
    public void setUserCredentialColumn(String userCredentialColumn) {
        this.userCredentialColumn = userCredentialColumn;
    }

    @UserHelpInfo(isRequired=true, getHelpText="Name of the users table - e.g. user_table", getInputType="text", getLabel="User Table")
    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    @UserHelpInfo(isRequired=true, getHelpText="User name column", getInputType="text", getLabel="User Name Column")
    public void setUserNameColumn(String userNameColumn) {
        this.userNameColumn = userNameColumn;
    }

    @UserHelpInfo(isRequired=false, getHelpText="Username of the connection, if there is one", getInputType="text", getLabel="Connection User Name")
    public void setConnectionUserName(String connectionUserName) {
        this.connectionUserName = connectionUserName;
    }

    @UserHelpInfo(isRequired=false, getHelpText="Password of the connection, if there is one", getInputType="password", getLabel="Connection Password")
    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    @UserHelpInfo(isRequired=true, getHelpText="e.g. jdbc:derby:home/identity/database/USER_DB", getInputType="text", getLabel="Connection URL")
    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    @UserHelpInfo(isRequired=true, getHelpText="Driver name - e.g. org.apache.derby.jdbc.EmbeddedDriver", getInputType="text", getLabel="Driver class")
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }
}

