/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.decoding;

import java.io.ByteArrayInputStream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml1.binding.decoding.BaseSAML1MessageDecoder;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostDecoder
extends BaseSAML1MessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostDecoder.class);

    public HTTPPostDecoder() {
    }

    public HTTPPostDecoder(ParserPool pool) {
        super(pool);
    }

    public HTTPPostDecoder(SAMLArtifactMap map) {
        super(map);
    }

    public HTTPPostDecoder(SAMLArtifactMap map, ParserPool pool) {
        super(map, pool);
    }

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this decoder only support SAMLMessageContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support SAMLMessageContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        HTTPInTransport inTransport = (HTTPInTransport)samlMsgCtx.getInboundMessageTransport();
        if (!inTransport.getHTTPMethod().equalsIgnoreCase("POST")) {
            throw new MessageDecodingException("This message deocoder only supports the HTTP POST method");
        }
        String relayState = inTransport.getParameterValue("TARGET");
        samlMsgCtx.setRelayState(relayState);
        this.log.debug("Decoded SAML relay state (TARGET parameter) of: {}", (Object)relayState);
        String base64Message = inTransport.getParameterValue("SAMLResponse");
        byte[] decodedBytes = Base64.decode(base64Message);
        if (decodedBytes == null) {
            this.log.error("Unable to Base64 decode SAML message");
            throw new MessageDecodingException("Unable to Base64 decode SAML message");
        }
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(new ByteArrayInputStream(decodedBytes));
        samlMsgCtx.setInboundMessage(inboundMessage);
        samlMsgCtx.setInboundSAMLMessage(inboundMessage);
        this.log.debug("Decoded SAML message");
        this.populateMessageContext(samlMsgCtx);
    }

    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return samlMsgCtx.getInboundSAMLMessage() instanceof ResponseAbstractType;
    }
}

