/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.bridge.CarbonHttpServletRequest;
import org.wso2.carbon.bridge.FrameworkLauncher;
import org.wso2.carbon.bridge.FrameworkLauncherFactory;

public class BridgeServlet
extends HttpServlet {
    private static final String CARBON_HOME = "carbon.home";
    private static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    private static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private FrameworkLauncher frameworkLauncher;
    private static BridgeServlet instance;
    private HttpServlet delegate;
    private static Lock lock;
    private boolean enableFrameworkControls;
    private boolean initiated = false;

    public void init() throws ServletException {
        String axis2Repo;
        String carbonRepo;
        if (this.initiated) {
            return;
        }
        this.initiated = true;
        BridgeServlet.setInstance(this);
        String carbonHome = System.getProperty(CARBON_HOME);
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            if (carbonHome != null) {
                System.setProperty(CARBON_HOME, carbonHome);
            } else {
                throw new ServletException("CARBON_HOME environment variable is not set. Can't proceed.");
            }
        }
        if ((carbonRepo = this.getInitParameter("carbonRepository")) != null) {
            System.setProperty("carbon.repository", carbonRepo);
            instance.getServletContext().log("Carbon Repository : " + carbonRepo);
        }
        if ((axis2Repo = this.getInitParameter("axis2Repository")) != null) {
            System.setProperty("axis2.repo", axis2Repo);
            instance.getServletContext().log("Axis2 Repository : " + axis2Repo);
        }
        try {
            String enableFrameworkControlsParameter = this.getServletConfig().getInitParameter("enableFrameworkControls");
            this.enableFrameworkControls = enableFrameworkControlsParameter != null && enableFrameworkControlsParameter.equals("true");
            this.frameworkLauncher = FrameworkLauncherFactory.getFrameworkLauncher();
            this.frameworkLauncher.init(this.getServletConfig());
            this.frameworkLauncher.deploy();
            this.frameworkLauncher.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!FrameworkLauncherFactory.getFrameworkLauncher().isRunning()) {
            return;
        }
        try {
            String pathInfo;
            req = new CarbonHttpServletRequest((HttpServletRequest)req);
            if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) == null) {
                pathInfo = req.getPathInfo();
                if (pathInfo == null && this.isExtensionMapping(req.getServletPath())) {
                    req = new ExtensionMappingRequest((HttpServletRequest)req);
                }
                if (this.enableFrameworkControls && pathInfo != null && pathInfo.startsWith("/sp_") && this.serviceFrameworkControls((HttpServletRequest)req, resp)) {
                    return;
                }
            } else {
                String servletPath;
                pathInfo = (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
                if ((pathInfo == null || pathInfo.length() == 0) && this.isExtensionMapping(servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE))) {
                    req = new IncludedExtensionMappingRequest((HttpServletRequest)req);
                }
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            HttpServlet servletReference = this.acquireDelegateReference();
            if (servletReference == null) {
                resp.sendError(404, "BridgeServlet: " + req.getRequestURI());
                return;
            }
            try {
                ClassLoader frameworkContextClassLoader = this.frameworkLauncher.getFrameworkContextClassLoader();
                if (frameworkContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(frameworkContextClassLoader);
                }
                servletReference.service((ServletRequest)req, (ServletResponse)resp);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
    }

    private synchronized HttpServlet acquireDelegateReference() {
        if (this.delegate != null) {
            // empty if block
        }
        return this.delegate;
    }

    private boolean isExtensionMapping(String servletPath) {
        if (servletPath == null) {
            return false;
        }
        String lastSegment = servletPath;
        int lastSlash = servletPath.lastIndexOf(47);
        if (lastSlash != -1) {
            lastSegment = servletPath.substring(lastSlash + 1);
        }
        return lastSegment.indexOf(46) != -1;
    }

    private static synchronized void setInstance(BridgeServlet servlet) {
        if (instance != null && servlet != null) {
            throw new IllegalStateException("instance already set");
        }
        instance = servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerServletDelegate(HttpServlet servletDelegate) {
        if (instance == null) {
            return;
        }
        if (servletDelegate == null) {
            throw new NullPointerException("cannot register a null servlet delegate");
        }
        lock.lock();
        try {
            if (BridgeServlet.instance.delegate != null) {
                throw new IllegalStateException("A Servlet Proxy is already registered");
            }
            try {
                servletDelegate.init(instance.getServletConfig());
            }
            catch (ServletException e) {
                instance.getServletContext().log("Error initializing servlet delegate", (Throwable)e);
                lock.unlock();
                return;
            }
            BridgeServlet.instance.delegate = servletDelegate;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unregisterServletDelegate(HttpServlet servletDelegate) {
        if (instance == null) {
            return;
        }
        lock.lock();
        try {
            if (BridgeServlet.instance.delegate == null) {
                throw new IllegalStateException("No servlet delegate is registered");
            }
            if (BridgeServlet.instance.delegate != servletDelegate) {
                throw new IllegalStateException("Servlet delegate does not match registered servlet delegate");
            }
            HttpServlet oldProxy = BridgeServlet.instance.delegate;
            BridgeServlet.instance.delegate = null;
            oldProxy.destroy();
        }
        finally {
            lock.unlock();
        }
    }

    public void destroy() {
        this.frameworkLauncher.stop();
        BridgeServlet.setInstance(null);
        super.destroy();
    }

    private boolean serviceFrameworkControls(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.equals("/sp_start")) {
            this.frameworkLauncher.start();
            resp.getWriter().write("Platform Started");
            return true;
        }
        if (pathInfo.equals("/sp_stop")) {
            this.frameworkLauncher.stop();
            resp.getWriter().write("Platform Stopped");
            return true;
        }
        if (pathInfo.equals("/sp_deploy")) {
            resp.getWriter().write("Platform Deployed");
            return true;
        }
        if (pathInfo.equals("/sp_undeploy")) {
            this.frameworkLauncher.undeploy();
            resp.getWriter().write("Platform Undeployed");
            return true;
        }
        if (pathInfo.equals("/sp_reset")) {
            this.frameworkLauncher.stop();
            this.frameworkLauncher.start();
            resp.getWriter().write("Platform Reset");
            return true;
        }
        if (pathInfo.equals("/sp_redeploy")) {
            this.frameworkLauncher.stop();
            this.frameworkLauncher.undeploy();
            this.frameworkLauncher.start();
            resp.getWriter().write("Platform Redeployed");
            return true;
        }
        if (pathInfo.equals("/sp_test")) {
            if (this.delegate == null) {
                resp.getWriter().write("Servlet delegate not registered.");
            } else {
                resp.getWriter().write("Servlet delegate registered - " + this.delegate.getClass().getName());
            }
            return true;
        }
        return false;
    }

    static {
        lock = new ReentrantLock();
    }

    private static class IncludedExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public IncludedExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public Object getAttribute(String attributeName) {
            if (attributeName.equals(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                return "";
            }
            if (attributeName.equals(BridgeServlet.INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String servletPath = (String)super.getAttribute(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE);
                return servletPath;
            }
            return super.getAttribute(attributeName);
        }
    }

    private static class ExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public ExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public String getPathInfo() {
            return super.getServletPath();
        }

        public String getServletPath() {
            return "";
        }
    }
}

