/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BridgeUtils {
    private static String JAR_TO_BUNDLE_DIR = System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") + "jarsToBundles" : System.getProperty("java.io.tmpdir") + File.separator + "jarsToBundles";

    public static File getBundleDirectory(String bundleDir) {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
        }
        if (carbonHome == null || carbonHome.length() == 0) {
            throw new RuntimeException("CARBON_HOME not found");
        }
        File dir = new File(carbonHome, bundleDir);
        if (dir.exists() || !dir.mkdirs()) {
            // empty if block
        }
        return dir;
    }

    public static void createBundle(File jarFile, File targetDir, Manifest mf, String extensionPrefix) throws IOException {
        if (mf == null) {
            mf = new Manifest();
        }
        String exportedPackages = BridgeUtils.parseJar(jarFile);
        String fileName = jarFile.getName();
        if ((fileName = fileName.replaceAll("-", "_")).endsWith(".jar")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        String symbolicName = extensionPrefix + fileName;
        String pluginName = extensionPrefix + fileName + "_1.0.0.jar";
        File extensionBundle = new File(targetDir, pluginName);
        Attributes attribs = mf.getMainAttributes();
        attribs.putValue("Manifest-Version", "1.0");
        attribs.putValue("Bundle-ManifestVersion", "2");
        attribs.putValue("Bundle-Name", fileName);
        attribs.putValue("Bundle-SymbolicName", symbolicName);
        attribs.putValue("Bundle-Version", "1.0.0");
        attribs.putValue("Export-Package", exportedPackages);
        attribs.putValue("Bundle-ClassPath", ".," + jarFile.getName());
        BridgeUtils.createBundle(jarFile, extensionBundle, mf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBundle(File jarFile, File bundle, Manifest manifest) throws IOException {
        String extractedDirPath = JAR_TO_BUNDLE_DIR + File.separator + System.currentTimeMillis() + Math.random();
        File extractedDir = new File(extractedDirPath);
        if (!extractedDir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + extractedDir.getAbsolutePath());
        }
        FileOutputStream mfos = null;
        FileOutputStream p2InfOs = null;
        try {
            BridgeUtils.copyFileToDir(jarFile, extractedDir);
            String metaInfPath = extractedDirPath + File.separator + "META-INF";
            if (!new File(metaInfPath).mkdirs()) {
                throw new IOException("Failed to create the directory: " + metaInfPath);
            }
            mfos = new FileOutputStream(metaInfPath + File.separator + "MANIFEST.MF");
            manifest.write(mfos);
            File p2InfFile = new File(metaInfPath + File.separator + "p2.inf");
            if (!p2InfFile.createNewFile()) {
                throw new IOException("Fail to create the file: " + p2InfFile.getAbsolutePath());
            }
            p2InfOs = new FileOutputStream(p2InfFile);
            p2InfOs.write("instructions.configure=markStarted(started:true);".getBytes());
            p2InfOs.flush();
            BridgeUtils.archiveDir(bundle.getAbsolutePath(), extractedDirPath);
            BridgeUtils.deleteDir(extractedDir);
        }
        finally {
            try {
                if (mfos != null) {
                    mfos.close();
                }
            }
            catch (IOException e) {}
            try {
                if (p2InfOs != null) {
                    p2InfOs.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String aChildren : children) {
                boolean success = BridgeUtils.deleteDir(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
        return true;
    }

    public static void archiveDir(String destArchive, String sourceDir) throws IOException {
        File zipDir = new File(sourceDir);
        if (!zipDir.isDirectory()) {
            throw new RuntimeException(sourceDir + " is not a directory");
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destArchive));
        BridgeUtils.zipDir(zipDir, zos, sourceDir);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void zipDir(File zipDir, ZipOutputStream zos, String archiveSourceDir) throws IOException {
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[40960];
        int bytesIn = 0;
        for (String aDirList : dirList) {
            File f = new File(zipDir, aDirList);
            zos.putNextEntry(new ZipEntry(BridgeUtils.getZipEntryPath(f, archiveSourceDir)));
            if (f.isDirectory()) {
                BridgeUtils.zipDir(f, zos, archiveSourceDir);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected static String getZipEntryPath(File f, String archiveSourceDir) {
        String entryPath = f.getPath();
        entryPath = entryPath.substring(archiveSourceDir.length() + 1);
        if (File.separatorChar == '\\') {
            entryPath = entryPath.replace(File.separatorChar, '/');
        }
        if (f.isDirectory()) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }

    public static void copyFileToDir(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        File file = new File(dstAbsPath + File.separator + src.getName());
        BridgeUtils.copyFile(src, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        OutputStream out = null;
        FileInputStream in = new FileInputStream(src);
        try {
            int len;
            String dstAbsPath = dst.getAbsolutePath();
            String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
            File dir = new File(dstDir);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
            }
            out = new FileOutputStream(dst);
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void extract(String archive, String extractDir) throws IOException {
        FileInputStream inputStream = new FileInputStream(archive);
        BridgeUtils.extractFromStream(inputStream, extractDir);
    }

    public static void extractFromStream(InputStream inputStream, String extractDir) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            File unzipped = new File(extractDir);
            zin = new ZipInputStream(inputStream);
            if (!unzipped.mkdirs()) {
                throw new IOException("Fail to create the directory: " + unzipped.getAbsolutePath());
            }
            while ((entry = zin.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                File f = new File(extractDir + File.separator + entryName);
                if (entryName.endsWith("/") && !f.exists()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Fail to create the directory: " + f.getAbsolutePath());
                }
                int lastIndexOfSlash = entryName.lastIndexOf("/");
                String dirPath = "";
                if (lastIndexOfSlash != -1) {
                    dirPath = entryName.substring(0, lastIndexOfSlash);
                    File dir = new File(extractDir + File.separator + dirPath);
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("Failed to create the directory: " + dir.getAbsoluteFile());
                    }
                }
                if (f.isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[40960];
                while ((len = zin.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            String msg = "Cannot unzip archive. It is probably corrupt";
            throw e;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String parseJar(File jarFile) throws IOException {
        ArrayList<String> exportedPackagesList = new ArrayList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
        List<ZipEntry> entries = BridgeUtils.populateList(zipInputStream);
        zipInputStream.close();
        for (ZipEntry entry : entries) {
            int index;
            String path = entry.getName();
            if (path.endsWith("/") || !path.endsWith(".class") || (index = path.lastIndexOf("/")) == -1) continue;
            path = path.substring(0, index);
            if (exportedPackagesList.contains(path = path.replaceAll("/", "."))) continue;
            exportedPackagesList.add(path);
        }
        String[] packageArray = exportedPackagesList.toArray(new String[exportedPackagesList.size()]);
        StringBuffer exportedPackages = new StringBuffer();
        for (int i = 0; i < packageArray.length; ++i) {
            exportedPackages.append(packageArray[i]);
            if (i == packageArray.length - 1) continue;
            exportedPackages.append(",");
        }
        return exportedPackages.toString();
    }

    private static List<ZipEntry> populateList(ZipInputStream zipInputStream) throws IOException {
        ZipEntry entry;
        ArrayList<ZipEntry> listEntry = new ArrayList<ZipEntry>();
        while (zipInputStream.available() == 1 && (entry = zipInputStream.getNextEntry()) != null) {
            listEntry.add(entry);
        }
        return listEntry;
    }

    static {
        File jarsToBundlesDir = new File(JAR_TO_BUNDLE_DIR);
        if (jarsToBundlesDir.exists()) {
            BridgeUtils.deleteDir(jarsToBundlesDir);
        }
    }

    public static class JarFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }
    }
}

