/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.PrologCodeWriter;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Messages;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.SecureLoader;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.xjc.reader.Util;
import com.sun.xml.bind.api.impl.NameConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public boolean debugMode;
    public boolean verbose;
    public boolean quiet;
    public boolean readOnly;
    public boolean noFileHeader;
    public boolean enableIntrospection;
    public boolean contentForWildcard;
    public String encoding;
    public boolean strictCheck = true;
    public boolean runtime14 = false;
    public boolean automaticNameConflictResolution = false;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    private static final Logger logger = com.sun.xml.bind.Util.getClassLogger();
    public SpecVersion target = SpecVersion.LATEST;
    private boolean is2_2 = true;
    public File targetDir = new File(".");
    public EntityResolver entityResolver = null;
    private Language schemaLanguage = null;
    public String defaultPackage = null;
    public String defaultPackage2 = null;
    private final List<InputSource> grammars = new ArrayList<InputSource>();
    private final List<InputSource> bindFiles = new ArrayList<InputSource>();
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    public final List<Plugin> activePlugins = new ArrayList<Plugin>();
    private List<Plugin> allPlugins;
    public final Set<String> pluginURIs = new HashSet<String>();
    public ClassNameAllocator classNameAllocator;
    public boolean packageLevelAnnotations = true;
    private FieldRendererFactory fieldRendererFactory = new FieldRendererFactory();
    private Plugin fieldRendererFactoryOwner = null;
    private NameConverter nameConverter = null;
    private Plugin nameConverterOwner = null;
    public final List<URL> classpaths = new ArrayList<URL>();
    private static String pluginLoadFailure;

    public boolean isExtensionMode() {
        return this.compatibilityMode == 2;
    }

    public Options() {
        if (this.is2_2) {
            try {
                Class.forName("javax.xml.bind.JAXBPermission");
            }
            catch (ClassNotFoundException cnfe) {
                this.is2_2 = false;
            }
            this.target = !this.is2_2 ? SpecVersion.V2_1 : SpecVersion.LATEST;
        }
    }

    public FieldRendererFactory getFieldRendererFactory() {
        return this.fieldRendererFactory;
    }

    public void setFieldRendererFactory(FieldRendererFactory frf, Plugin owner) throws BadCommandLineException {
        if (frf == null) {
            throw new IllegalArgumentException();
        }
        if (this.fieldRendererFactoryOwner != null) {
            throw new BadCommandLineException(Messages.format("FIELD_RENDERER_CONFLICT", this.fieldRendererFactoryOwner.getOptionName(), owner.getOptionName()));
        }
        this.fieldRendererFactoryOwner = owner;
        this.fieldRendererFactory = frf;
    }

    public NameConverter getNameConverter() {
        return this.nameConverter;
    }

    public void setNameConverter(NameConverter nc, Plugin owner) throws BadCommandLineException {
        if (nc == null) {
            throw new IllegalArgumentException();
        }
        if (this.nameConverter != null) {
            throw new BadCommandLineException(Messages.format("NAME_CONVERTER_CONFLICT", this.nameConverterOwner.getOptionName(), owner.getOptionName()));
        }
        this.nameConverterOwner = owner;
        this.nameConverter = nc;
    }

    public List<Plugin> getAllPlugins() {
        if (this.allPlugins == null) {
            this.allPlugins = new ArrayList<Plugin>();
            URLClassLoader ucl = this.getUserClassLoader(SecureLoader.getClassClassLoader(this.getClass()));
            this.allPlugins.addAll(Arrays.asList(Options.findServices(Plugin.class, ucl)));
        }
        return this.allPlugins;
    }

    public Language getSchemaLanguage() {
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(Language _schemaLanguage) {
        this.schemaLanguage = _schemaLanguage;
    }

    public InputSource[] getGrammars() {
        return this.grammars.toArray(new InputSource[this.grammars.size()]);
    }

    public void addGrammar(InputSource is) {
        this.grammars.add(this.absolutize(is));
    }

    private InputSource fileToInputSource(File source) {
        try {
            String url = source.toURL().toExternalForm();
            return new InputSource(Util.escapeSpace(url));
        }
        catch (MalformedURLException e) {
            return new InputSource(source.getPath());
        }
    }

    public void addGrammar(File source) {
        this.addGrammar(this.fileToInputSource(source));
    }

    public void addGrammarRecursive(File dir) {
        this.addRecursive(dir, ".xsd", this.grammars);
    }

    private void addRecursive(File dir, String suffix, List<InputSource> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.addRecursive(f, suffix, result);
                continue;
            }
            if (!f.getPath().endsWith(suffix)) continue;
            result.add(this.absolutize(this.fileToInputSource(f)));
        }
    }

    private InputSource absolutize(InputSource is) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURL();
            is.setSystemId(new URL(baseURL, is.getSystemId()).toExternalForm());
        }
        catch (IOException e) {
            logger.log(Level.FINE, "{0}, {1}", new Object[]{is.getSystemId(), e.getLocalizedMessage()});
        }
        return is;
    }

    public InputSource[] getBindFiles() {
        return this.bindFiles.toArray(new InputSource[this.bindFiles.size()]);
    }

    public void addBindFile(InputSource is) {
        this.bindFiles.add(this.absolutize(is));
    }

    public void addBindFile(File bindFile) {
        this.bindFiles.add(this.fileToInputSource(bindFile));
    }

    public void addBindFileRecursive(File dir) {
        this.addRecursive(dir, ".xjb", this.bindFiles);
    }

    public URLClassLoader getUserClassLoader(ClassLoader parent) {
        return new URLClassLoader(this.classpaths.toArray(new URL[this.classpaths.size()]), parent);
    }

    public int parseArgument(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-classpath") || args[i].equals("-cp")) {
            String a = this.requireArgument(args[i], args, ++i);
            for (String p : a.split(File.pathSeparator)) {
                File file = new File(p);
                try {
                    this.classpaths.add(file.toURL());
                }
                catch (MalformedURLException e) {
                    throw new BadCommandLineException(Messages.format("Driver.NotAValidFileName", file), e);
                }
            }
            return 2;
        }
        if (args[i].equals("-d")) {
            this.targetDir = new File(this.requireArgument("-d", args, ++i));
            if (!this.targetDir.exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NonExistentDir", this.targetDir));
            }
            return 2;
        }
        if (args[i].equals("-readOnly")) {
            this.readOnly = true;
            return 1;
        }
        if (args[i].equals("-p")) {
            this.defaultPackage = this.requireArgument("-p", args, ++i);
            if (this.defaultPackage.length() == 0) {
                this.packageLevelAnnotations = false;
            }
            return 2;
        }
        if (args[i].equals("-debug")) {
            this.debugMode = true;
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-nv")) {
            this.strictCheck = false;
            return 1;
        }
        if (args[i].equals("-npa")) {
            this.packageLevelAnnotations = false;
            return 1;
        }
        if (args[i].equals("-no-header")) {
            this.noFileHeader = true;
            return 1;
        }
        if (args[i].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (args[i].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (args[i].equals("-XexplicitAnnotation")) {
            this.runtime14 = true;
            return 1;
        }
        if (args[i].equals("-enableIntrospection")) {
            this.enableIntrospection = true;
            return 1;
        }
        if (args[i].equals("-contentForWildcard")) {
            this.contentForWildcard = true;
            return 1;
        }
        if (args[i].equals("-XautoNameResolution")) {
            this.automaticNameConflictResolution = true;
            return 1;
        }
        if (args[i].equals("-b")) {
            this.addFile(this.requireArgument("-b", args, ++i), this.bindFiles, ".xjb");
            return 2;
        }
        if (args[i].equals("-dtd")) {
            this.schemaLanguage = Language.DTD;
            return 1;
        }
        if (args[i].equals("-relaxng")) {
            this.schemaLanguage = Language.RELAXNG;
            return 1;
        }
        if (args[i].equals("-relaxng-compact")) {
            this.schemaLanguage = Language.RELAXNG_COMPACT;
            return 1;
        }
        if (args[i].equals("-xmlschema")) {
            this.schemaLanguage = Language.XMLSCHEMA;
            return 1;
        }
        if (args[i].equals("-wsdl")) {
            this.schemaLanguage = Language.WSDL;
            return 1;
        }
        if (args[i].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (args[i].equals("-target")) {
            String token = this.requireArgument("-target", args, ++i);
            this.target = SpecVersion.parse(token);
            if (this.target == null) {
                throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_TARGET_VERSION", token));
            }
            return 2;
        }
        if (args[i].equals("-httpproxyfile")) {
            File file;
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXYFILE", new Object[0]));
            }
            if (!(file = new File(args[++i])).exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NO_SUCH_FILE", file));
            }
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.parseProxy(in.readLine());
                in.close();
            }
            catch (IOException e) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", file, e.getMessage()), e);
            }
            return 2;
        }
        if (args[i].equals("-httpproxy")) {
            if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXY", new Object[0]));
            }
            this.parseProxy(args[++i]);
            return 2;
        }
        if (args[i].equals("-host")) {
            this.proxyHost = this.requireArgument("-host", args, ++i);
            return 2;
        }
        if (args[i].equals("-port")) {
            this.proxyPort = this.requireArgument("-port", args, ++i);
            return 2;
        }
        if (args[i].equals("-catalog")) {
            File catalogFile = new File(this.requireArgument("-catalog", args, ++i));
            try {
                this.addCatalog(catalogFile);
            }
            catch (IOException e) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", catalogFile, e.getMessage()), e);
            }
            return 2;
        }
        if (args[i].equals("-source")) {
            String version;
            if (!(version = this.requireArgument("-source", args, ++i)).equals("2.0") && !version.equals("2.1")) {
                throw new BadCommandLineException(Messages.format("Driver.DefaultVersion", new Object[0]));
            }
            return 2;
        }
        if (args[i].equals("-Xtest-class-name-allocator")) {
            this.classNameAllocator = new ClassNameAllocator(){

                public String assignClassName(String packageName, String className) {
                    System.out.printf("assignClassName(%s,%s)\n", packageName, className);
                    return className + "_Type";
                }
            };
            return 1;
        }
        if (args[i].equals("-encoding")) {
            this.encoding = this.requireArgument("-encoding", args, ++i);
            try {
                if (!Charset.isSupported(this.encoding)) {
                    throw new BadCommandLineException(Messages.format("Driver.UnsupportedEncoding", this.encoding));
                }
            }
            catch (IllegalCharsetNameException icne) {
                throw new BadCommandLineException(Messages.format("Driver.UnsupportedEncoding", this.encoding));
            }
            return 2;
        }
        for (Plugin plugin : this.getAllPlugins()) {
            try {
                int r;
                if (('-' + plugin.getOptionName()).equals(args[i])) {
                    this.activePlugins.add(plugin);
                    plugin.onActivated(this);
                    this.pluginURIs.addAll(plugin.getCustomizationURIs());
                    r = plugin.parseArgument(this, args, i);
                    if (r != 0) {
                        return r;
                    }
                    return 1;
                }
                r = plugin.parseArgument(this, args, i);
                if (r == 0) continue;
                return r;
            }
            catch (IOException e) {
                throw new BadCommandLineException(e.getMessage(), e);
            }
        }
        return 0;
    }

    private void parseProxy(String text) throws BadCommandLineException {
        String token = "([^@:]+)";
        Pattern p = Pattern.compile("(?:" + token + "(?:\\:" + token + ")?\\@)?" + token + "(?:\\:" + token + ")");
        Matcher matcher = p.matcher(text);
        if (!matcher.matches()) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", text));
        }
        this.proxyUser = matcher.group(1);
        this.proxyPassword = matcher.group(2);
        this.proxyHost = matcher.group(3);
        this.proxyPort = matcher.group(4);
        try {
            Integer.valueOf(this.proxyPort);
        }
        catch (NumberFormatException e) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", text));
        }
    }

    public String requireArgument(String optionName, String[] args, int i) throws BadCommandLineException {
        if (i == args.length || args[i].startsWith("-")) {
            throw new BadCommandLineException(Messages.format("Driver.MissingOperand", optionName));
        }
        return args[i];
    }

    private void addFile(String name, List<InputSource> target, String suffix) throws BadCommandLineException {
        Object src;
        try {
            src = Util.getFileOrURL(name);
        }
        catch (IOException e) {
            throw new BadCommandLineException(Messages.format("Driver.NotAFileNorURL", name));
        }
        if (src instanceof URL) {
            target.add(this.absolutize(new InputSource(Util.escapeSpace(((URL)src).toExternalForm()))));
        } else {
            File fsrc = (File)src;
            if (fsrc.isDirectory()) {
                this.addRecursive(fsrc, suffix, target);
            } else {
                target.add(this.absolutize(this.fileToInputSource(fsrc)));
            }
        }
    }

    public void addCatalog(File catalogFile) throws IOException {
        if (this.entityResolver == null) {
            CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
            this.entityResolver = new CatalogResolver(true);
        }
        ((CatalogResolver)this.entityResolver).getCatalog().parseCatalog(catalogFile.getPath());
    }

    public void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArgument(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(Messages.format("Driver.UnrecognizedParameter", args[i]));
                }
                i += j - 1;
                continue;
            }
            if (args[i].endsWith(".jar")) {
                this.scanEpisodeFile(new File(args[i]));
                continue;
            }
            this.addFile(args[i], this.grammars, ".xsd");
        }
        if (this.proxyHost != null || this.proxyPort != null) {
            if (this.proxyHost == null || this.proxyPort == null) {
                if (this.proxyHost == null) {
                    throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost", new Object[0]));
                }
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort", new Object[0]));
            }
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            System.setProperty("https.proxyHost", this.proxyHost);
            System.setProperty("https.proxyPort", this.proxyPort);
            if (this.proxyUser != null) {
                System.setProperty("http.proxyUser", this.proxyUser);
            }
            if (this.proxyPassword != null) {
                System.setProperty("http.proxyPassword", this.proxyPassword);
            }
        }
        if (this.grammars.isEmpty()) {
            throw new BadCommandLineException(Messages.format("Driver.MissingGrammar", new Object[0]));
        }
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
        if (pluginLoadFailure != null) {
            throw new BadCommandLineException(Messages.format("PLUGIN_LOAD_FAILURE", pluginLoadFailure));
        }
    }

    public void scanEpisodeFile(File jar) throws BadCommandLineException {
        try {
            URLClassLoader ucl = new URLClassLoader(new URL[]{jar.toURL()});
            Enumeration<URL> resources = ucl.findResources("META-INF/sun-jaxb.episode");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.addBindFile(new InputSource(url.toExternalForm()));
            }
        }
        catch (IOException e) {
            throw new BadCommandLineException(Messages.format("FAILED_TO_LOAD", jar, e.getMessage()), e);
        }
    }

    public Language guessSchemaLanguage() {
        if (this.grammars != null && this.grammars.size() > 0) {
            String name = this.grammars.get(0).getSystemId().toLowerCase();
            if (name.endsWith(".rng")) {
                return Language.RELAXNG;
            }
            if (name.endsWith(".rnc")) {
                return Language.RELAXNG_COMPACT;
            }
            if (name.endsWith(".dtd")) {
                return Language.DTD;
            }
            if (name.endsWith(".wsdl")) {
                return Language.WSDL;
            }
        }
        return Language.XMLSCHEMA;
    }

    public CodeWriter createCodeWriter() throws IOException {
        return this.createCodeWriter(new FileCodeWriter(this.targetDir, this.readOnly, this.encoding));
    }

    public CodeWriter createCodeWriter(CodeWriter core) {
        if (this.noFileHeader) {
            return core;
        }
        return new PrologCodeWriter(core, this.getPrologComment());
    }

    public String getPrologComment() {
        String format = Messages.format("Driver.DateFormat", new Object[0]) + " '" + Messages.format("Driver.At", new Object[0]) + "' " + Messages.format("Driver.TimeFormat", new Object[0]);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.ENGLISH);
        return Messages.format("Driver.FilePrologComment", dateFormat.format(new Date()));
    }

    private static <T> T[] findServices(Class<T> clazz, ClassLoader classLoader) {
        boolean debug = com.sun.tools.xjc.util.Util.getSystemProperty(Options.class, "findServices") != null;
        try {
            Class<?> serviceLoader = Class.forName("java.util.ServiceLoader");
            if (debug) {
                System.out.println("Using java.util.ServiceLoader");
            }
            Iterable itr = (Iterable)serviceLoader.getMethod("load", Class.class, ClassLoader.class).invoke(null, clazz, classLoader);
            ArrayList r = new ArrayList();
            for (Object t : itr) {
                r.add(t);
            }
            return r.toArray((Object[])Array.newInstance(clazz, r.size()));
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            Throwable x = e.getTargetException();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new Error(x);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError x = new NoSuchMethodError();
            x.initCause(e);
            throw x;
        }
        String serviceId = "META-INF/services/" + clazz.getName();
        HashSet<String> classNames = new HashSet<String>();
        if (debug) {
            System.out.println("Looking for " + serviceId + " for add-ons");
        }
        try {
            Enumeration<URL> e = classLoader.getResources(serviceId);
            if (e == null) {
                return (Object[])Array.newInstance(clazz, 0);
            }
            ArrayList<T> a = new ArrayList<T>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                BufferedReader reader = null;
                if (debug) {
                    System.out.println("Checking " + url + " for an add-on");
                }
                try {
                    String impl;
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    while ((impl = reader.readLine()) != null) {
                        if (!classNames.add(impl = impl.trim())) continue;
                        Class<?> implClass = classLoader.loadClass(impl);
                        if (!clazz.isAssignableFrom(implClass)) {
                            pluginLoadFailure = impl + " is not a subclass of " + clazz + ". Skipping";
                            if (!debug) continue;
                            System.out.println(pluginLoadFailure);
                            continue;
                        }
                        if (debug) {
                            System.out.println("Attempting to instanciate " + impl);
                        }
                        a.add(clazz.cast(implClass.newInstance()));
                    }
                    reader.close();
                }
                catch (Exception ex) {
                    StringWriter w = new StringWriter();
                    ex.printStackTrace(new PrintWriter(w));
                    pluginLoadFailure = w.toString();
                    if (debug) {
                        System.out.println(pluginLoadFailure);
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException ex2) {}
                }
            }
            return a.toArray((Object[])Array.newInstance(clazz, a.size()));
        }
        catch (Throwable e) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            pluginLoadFailure = w.toString();
            if (debug) {
                System.out.println(pluginLoadFailure);
            }
            return (Object[])Array.newInstance(clazz, 0);
        }
    }

    public static String getBuildID() {
        return Messages.format("Driver.BuildID", new Object[0]);
    }

    public static String normalizeSystemId(String systemId) {
        try {
            systemId = new URI(systemId).normalize().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return systemId;
    }
}

