/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.AuthenticationFailureException;
import org.wso2.carbon.core.services.authentication.AuthenticationUtil;
import org.wso2.carbon.core.services.authentication.RememberMeData;
import org.wso2.carbon.core.services.authentication.ServerAuthenticator;
import org.wso2.carbon.core.services.internal.CarbonServicesServiceComponent;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public abstract class AbstractAuthenticator
extends AbstractAdmin
implements ServerAuthenticator {
    protected static final int DEFAULT_PRIORITY_LEVEL = 4;
    private static final Log log = LogFactory.getLog(AbstractAuthenticator.class);

    @Override
    public boolean isAuthenticated(MessageContext msgContext) {
        String userLoggedIn;
        HttpSession httpSession = this.getHttpSession(msgContext);
        if (httpSession != null && (userLoggedIn = (String)httpSession.getAttribute("wso2carbon.admin.logged.in")) != null) {
            try {
                this.onSuccessLogin(httpSession, userLoggedIn);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while initializing user session.", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean continueProcessing(MessageContext messageContext) {
        String continueProcessing = (String)messageContext.getProperty("org.wso2.carbon.core.services.authentication.continue");
        return continueProcessing == null || !continueProcessing.equals("false");
    }

    @Override
    public void authenticate(MessageContext msgContext) throws AuthenticationFailureException {
        int tenantId;
        String tenantDomain;
        RealmService realmService;
        String userNameInRequest = this.getUserNameFromRequest(msgContext);
        if (userNameInRequest == null) {
            log.debug((Object)"Could not retrieve user name for authentication from request");
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.INVALID_USER_NAME);
        }
        String domainNameFromUserName = CarbonAuthenticationUtil.extractTenantDomain(userNameInRequest);
        if (domainNameFromUserName != null && domainNameFromUserName.equals("carbon.super")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authentication Failure..Provided tenant domain name is reserved..");
            }
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.RESERVED_TENANT_DOMAIN, userNameInRequest);
        }
        try {
            realmService = this.getRealmService();
        }
        catch (Exception e) {
            log.error((Object)"Unable retrieve Realm service", (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
        try {
            tenantDomain = this.getTenantDomain(userNameInRequest, realmService);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to retrieve tenant domain for user " + userNameInRequest + " this could most " + "probably due to invalid user name"), (Throwable)e);
            }
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.INVALID_USER_NAME, userNameInRequest);
        }
        try {
            tenantId = this.getTenantId(tenantDomain);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)("Unable retrieve tenant id for tenant domain " + tenantDomain), (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Doing authentication for tenant id " + tenantId + " and user " + userNameInRequest));
        }
        try {
            this.notifyAuthenticationStarted(tenantId);
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while executing pre authenticating tasks.", (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
        String remoteAddress = this.getRemoteAddress(msgContext);
        String tenantLessUserName = MultitenantUtils.getTenantAwareUsername((String)userNameInRequest);
        try {
            this.doAuthentication(userNameInRequest, tenantId, msgContext);
        }
        catch (AuthenticationFailureException e) {
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder("Did authentication for user ").append(userNameInRequest).append(" and for tenant id ").append(tenantId).append(" result is - authentication failed !!").append(" reason - ").append(e.getMessage());
                log.debug((Object)stringBuilder.toString());
            }
            try {
                this.onFailedLogin(tenantLessUserName, tenantId, remoteAddress, e.getMessage(), msgContext);
            }
            catch (Exception e1) {
                log.error((Object)("Unable to execute post authentication operation on failed login attempt. User - " + userNameInRequest), (Throwable)e1);
            }
            throw e;
        }
        try {
            this.onSuccessLogin(tenantLessUserName, tenantId, tenantDomain, remoteAddress, msgContext);
        }
        catch (Exception e) {
            log.error((Object)("Unable to execute post authentication operations in a successful login. User - " + userNameInRequest), (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
        if (this.isRememberMeRequest(userNameInRequest, msgContext)) {
            try {
                RememberMeData rememberMeData = this.persistsRememberMeData(userNameInRequest);
                this.populateRememberMeDataInReply(rememberMeData.getValue(), rememberMeData.getMaxAge(), msgContext);
            }
            catch (Exception e) {
                log.error((Object)"Unable to persists RememberMe cookie.", (Throwable)e);
                throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
            }
        }
    }

    protected RememberMeData persistsRememberMeData(String userName) throws Exception {
        String uuid = UUID.randomUUID().toString();
        RememberMeData data = new RememberMeData();
        data.setMaxAge(604800);
        data.setValue(userName + "-" + uuid);
        RealmService realmService = CarbonServicesServiceComponent.getRealmService();
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        UserRealm realm = realmService.getTenantUserRealm(tenantId);
        realm.getUserStoreManager().addRememberMe(userName, uuid);
        data.setAuthenticated(true);
        return data;
    }

    protected void onSuccessLogin(String userName, int tenantId, String tenantDomain, String remoteAddress, MessageContext msgContext) throws Exception {
        CarbonAuthenticationUtil.onSuccessAdminLogin(this.getHttpSession(msgContext), userName, tenantId, tenantDomain, remoteAddress);
        this.notifyAuthenticationCompleted(tenantId, true);
    }

    protected void onSuccessLogin(HttpSession httpSession, String userName) throws Exception {
        if (httpSession.getAttribute("WSO2RegistryRoot") != null) {
            return;
        }
        String tenantDomain = this.getTenantDomain();
        int tenantId = this.getTenantId(tenantDomain);
        CarbonAuthenticationUtil.initializeLoggedInUserRegistry(httpSession, userName, tenantId, tenantDomain);
    }

    protected HttpSession getHttpSession(MessageContext msgContext) {
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null) {
            return request.getSession();
        }
        return null;
    }

    protected void onFailedLogin(String userName, int tenantId, String remoteAddress, String reason, MessageContext messageContext) throws Exception {
        CarbonAuthenticationUtil.onFailedAdminLogin(this.getHttpSession(messageContext), userName, tenantId, remoteAddress, reason);
        this.notifyAuthenticationCompleted(tenantId, false);
    }

    protected String getRemoteAddress(MessageContext msgCtx) {
        try {
            return AuthenticationUtil.getRemoteAddress(msgCtx);
        }
        catch (AuthenticationException e) {
            log.error((Object)"Invalid remote address detected.", (Throwable)e);
            return null;
        }
    }

    protected void notifyAuthenticationStarted(int tenantId) throws Exception {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        } else {
            log.debug((Object)"BundleContext is null. Could not update AuthenticationObservers !!");
        }
    }

    protected void notifyAuthenticationCompleted(int tenantId, boolean successful) throws Exception {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).completedAuthentication(tenantId, successful);
                }
            }
            tracker.close();
        } else {
            log.debug((Object)"BundleContext is null. Could not update AuthenticationObservers !!");
        }
    }

    protected String getTenantDomain(String userName, RealmService realmService) throws UserStoreException {
        return MultitenantUtils.getTenantDomain((String)userName);
    }

    protected int getTenantId(String tenantDomain) throws org.wso2.carbon.user.api.UserStoreException {
        try {
            return this.getRealmService().getTenantManager().getTenantId(tenantDomain);
        }
        catch (Exception e) {
            throw new org.wso2.carbon.user.api.UserStoreException("Unable to retrieve Realm service for authentication");
        }
    }

    @Override
    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(this.getAuthenticatorName());
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return -1;
    }

    protected abstract String getUserNameFromRequest(MessageContext var1);

    protected abstract void doAuthentication(String var1, int var2, MessageContext var3) throws AuthenticationFailureException;

    protected boolean isRememberMeRequest(String userNameInRequest, MessageContext messageContext) {
        return false;
    }

    protected void populateRememberMeDataInReply(String uidValue, int maxAge, MessageContext messageContext) {
    }

    protected abstract RealmService getRealmService() throws Exception;

    protected abstract BundleContext getBundleContext() throws Exception;
}

