/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

public class AuthenticationFailureException
extends Exception {
    private AuthenticationFailureReason authenticationFailureReason;
    private String parameter;

    public AuthenticationFailureException(AuthenticationFailureReason reason) {
        this.authenticationFailureReason = reason;
    }

    public AuthenticationFailureException(AuthenticationFailureReason reason, String parameter) {
        this.authenticationFailureReason = reason;
        this.parameter = parameter;
    }

    public AuthenticationFailureReason getAuthenticationFailureReason() {
        return this.authenticationFailureReason;
    }

    public String getParameter() {
        return this.parameter;
    }

    @Override
    public String getMessage() {
        if (this.authenticationFailureReason == AuthenticationFailureReason.INVALID_USER_NAME) {
            return "Authentication failed - Invalid user name provided." + this.parameter;
        }
        if (this.authenticationFailureReason == AuthenticationFailureReason.INVALID_PASSWORD) {
            return "Authentication failed - Invalid credentials provided.";
        }
        if (this.authenticationFailureReason == AuthenticationFailureReason.SYSTEM_ERROR) {
            return "Authentication failed - System error occurred. Please check server logs for more details.";
        }
        if (this.authenticationFailureReason == AuthenticationFailureReason.RESERVED_TENANT_DOMAIN) {
            return "Authentication failed - System error occurred. Tenant domain name is reserved.";
        }
        throw new RuntimeException("Un-identified authentication failure reason");
    }

    public static enum AuthenticationFailureReason {
        INVALID_USER_NAME,
        INVALID_PASSWORD,
        SYSTEM_ERROR,
        RESERVED_TENANT_DOMAIN;

    }
}

