/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import java.util.Calendar;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.services.authentication.AbstractAuthenticator;
import org.wso2.carbon.core.services.authentication.AuthenticationFailureException;
import org.wso2.carbon.core.services.authentication.AuthenticationUtil;
import org.wso2.carbon.core.services.authentication.AuthenticatorHelper;
import org.wso2.carbon.core.services.internal.CarbonServicesServiceComponent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BasicAccessAuthenticator
extends AbstractAuthenticator {
    private static final String AUTHENTICATOR_NAME = "BasicAccessAuthenticator";
    private static final String CARBON_BASIC_AUTH_PASSWORD = "CARBON_BASIC_AUTH_PASSWORD";
    private static final Log log = LogFactory.getLog(BasicAccessAuthenticator.class);

    @Override
    protected String getUserNameFromRequest(MessageContext msgContext) {
        String authorizationHeader = AuthenticationUtil.getHeader("Authorization", msgContext);
        if (authorizationHeader == null) {
            log.debug((Object)"Authorization header missing !!");
            this.createUnAuthorizedResponse(msgContext);
        } else {
            String[] userNamePassword = this.decodeAuthorizationHeader(authorizationHeader);
            if (userNamePassword.length != 2) {
                log.debug((Object)"Invalid authorization header received");
                this.createUnAuthorizedResponse(msgContext);
            } else if (userNamePassword[0] == null || userNamePassword[0].isEmpty()) {
                this.createUnAuthorizedResponse(msgContext);
            } else if (userNamePassword[1] == null || userNamePassword[1].isEmpty()) {
                this.createUnAuthorizedResponse(msgContext);
            } else {
                msgContext.setProperty(CARBON_BASIC_AUTH_PASSWORD, (Object)userNamePassword[1]);
                return userNamePassword[0];
            }
        }
        return null;
    }

    private void createUnAuthorizedResponse(MessageContext msgContext) {
        String serverName = ServerConfiguration.getInstance().getFirstProperty("Name");
        HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (response != null) {
            response.setStatus(401);
            response.addHeader("Server", "WSO2 Server");
            response.addDateHeader("Date", Calendar.getInstance().getTimeInMillis());
            response.addHeader("WWW-Authenticate", "Basic realm=\"" + serverName + "\"");
            response.setContentType("text/html");
        } else {
            msgContext.setProperty("NIO-ACK-Requested", (Object)"true");
            msgContext.setProperty("HTTP_SC", (Object)401);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("WWW-Authenticate", "Basic realm=\"" + serverName + "\"");
            responseHeaders.put("Server", "WSO2 Server");
            responseHeaders.put("Date", Long.toString(Calendar.getInstance().getTimeInMillis()));
            msgContext.setProperty("TRANSPORT_HEADERS", responseHeaders);
        }
        msgContext.setProperty("org.wso2.carbon.core.services.authentication.continue", (Object)"false");
        RequestResponseTransport transportControl = (RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl");
        if (transportControl != null) {
            transportControl.setResponseWritten(true);
        }
    }

    private String[] decodeAuthorizationHeader(String authorizationHeader) {
        String[] splitValues = authorizationHeader.trim().split(" ");
        byte[] decodedBytes = Base64Utils.decode((String)splitValues[1].trim());
        if (decodedBytes != null) {
            String userNamePassword = new String(decodedBytes);
            return userNamePassword.split(":");
        }
        log.debug((Object)"Error decoding authorization header. Could not retrieve user name and password.");
        return new String[]{null, null};
    }

    @Override
    protected void doAuthentication(String userNameInRequest, int tenantId, MessageContext msgContext) throws AuthenticationFailureException {
        UserRealm realm;
        try {
            RegistryService registryService = CarbonServicesServiceComponent.getRegistryService();
            realm = AuthenticatorHelper.getUserRealm(tenantId, this.getRealmService(), registryService);
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving user realm for authentication. Tenant id " + tenantId + " user name " + userNameInRequest), (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
        String userName = MultitenantUtils.getTenantAwareUsername((String)userNameInRequest);
        String password = (String)msgContext.getProperty(CARBON_BASIC_AUTH_PASSWORD);
        if (password == null) {
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.INVALID_PASSWORD, userNameInRequest);
        }
        try {
            boolean isAuthenticated = realm.getUserStoreManager().authenticate(userName, (Object)password);
            if (!isAuthenticated) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed authentication for user " + userNameInRequest));
                }
                throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.INVALID_PASSWORD, userNameInRequest);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Unable to get UserStoreManager for authentication. User - " + userNameInRequest), (Throwable)e);
            throw new AuthenticationFailureException(AuthenticationFailureException.AuthenticationFailureReason.SYSTEM_ERROR, userNameInRequest);
        }
    }

    @Override
    protected RealmService getRealmService() throws Exception {
        return CarbonServicesServiceComponent.getRealmService();
    }

    @Override
    protected BundleContext getBundleContext() throws Exception {
        return CarbonServicesServiceComponent.getBundleContext();
    }

    @Override
    public boolean canHandle(MessageContext msgContext) {
        String authorizationHeader = AuthenticationUtil.getHeader("Authorization", msgContext);
        if (authorizationHeader == null) {
            return true;
        }
        String authType = this.getAuthType(authorizationHeader);
        return authType != null && authType.equalsIgnoreCase("Basic");
    }

    protected String getAuthType(String authorizationHeader) {
        String[] splitValues = authorizationHeader.trim().split(" ");
        if (splitValues == null || splitValues.length == 0) {
            return null;
        }
        return splitValues[0].trim();
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    protected boolean isRememberMeRequest(String userNameInRequest, MessageContext messageContext) {
        String rememberMeHeader = AuthenticationUtil.getHeader("RememberMe", messageContext);
        return rememberMeHeader != null && rememberMeHeader.equals("true");
    }

    @Override
    protected void populateRememberMeDataInReply(String uidValue, int maxAge, MessageContext messageContext) {
        HttpServletResponse response = (HttpServletResponse)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (response != null) {
            response.addHeader("RememberMeCookieValue", uidValue);
            response.addHeader("RememberMeCookieAge", Integer.toString(maxAge));
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("RememberMeCookieValue", uidValue);
        responseHeaders.put("RememberMeCookieAge", Integer.toString(maxAge));
        messageContext.setProperty("TRANSPORT_HEADERS", responseHeaders);
    }

    @Override
    public int getPriority() {
        int configuredPriority = super.getPriority();
        if (configuredPriority == -1) {
            return 4;
        }
        return configuredPriority;
    }
}

