/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.fileupload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.common.IFileUpload;
import org.wso2.carbon.core.common.UploadedFileItem;

public class FileUploadService
extends AbstractAdmin
implements IFileUpload {
    public String[] uploadFiles(UploadedFileItem[] uploadedFileItems) throws Exception {
        try {
            ConfigurationContext configurationContext = this.getConfigContext();
            HashMap<String, String> fileResourceMap = (HashMap<String, String>)configurationContext.getProperty("file.resource.map");
            boolean multiItems = false;
            if (uploadedFileItems.length > 1) {
                multiItems = true;
            }
            ArrayList<String> uuidList = new ArrayList<String>(uploadedFileItems.length);
            for (UploadedFileItem fileItem : uploadedFileItems) {
                String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                String extraFileLocation = configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
                File dirs = new File(extraFileLocation);
                if (!dirs.exists()) {
                    dirs.mkdirs();
                }
                File uploadedFile = new File(extraFileLocation, this.getFileName(fileItem.getFileName()));
                String fileName = fileItem.getFileName();
                if ((fileName == null || fileName.length() == 0) && multiItems) continue;
                fileItem.getDataHandler().writeTo((OutputStream)new FileOutputStream(uploadedFile));
                if (fileResourceMap == null) {
                    fileResourceMap = new HashMap<String, String>();
                    configurationContext.setProperty("file.resource.map", fileResourceMap);
                }
                fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                uuidList.add(uuid);
            }
            String[] uuidArray = new String[uuidList.size()];
            uuidArray = uuidList.toArray(uuidArray);
            return uuidArray;
        }
        catch (Exception e) {
            throw new AxisFault("Error occurred while uploading service artifacts", (Throwable)e);
        }
    }

    private String getFileName(String fileName) {
        String fileNameOnly = fileName.indexOf("\\") < 0 ? fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length()) : fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length());
        return fileNameOnly;
    }
}

