/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.MembershipListener;
import org.apache.axis2.clustering.tribes.TribesClusteringAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.InstanceStateNotificationClientThread;
import org.apache.stratos.cartridge.agent.RegistrantMembershipListener;
import org.apache.stratos.cartridge.agent.exception.CartridgeAgentException;
import org.apache.stratos.cartridge.agent.registrant.PortMapping;
import org.apache.stratos.cartridge.agent.registrant.Registrant;
import org.apache.stratos.cartridge.agent.registrant.RegistrantDatabase;
import org.apache.stratos.cartridge.agent.registrant.RegistrantUtil;
import org.apache.stratos.cartridge.messages.CreateClusterDomainMessage;
import org.apache.stratos.cartridge.messages.CreateRemoveClusterDomainMessage;

public class ClusteringClient {
    private static final Log log = LogFactory.getLog(ClusteringClient.class);
    public static final Random RANDOM = new Random();
    private Properties conf;
    private RegistrantDatabase registrantDatabase;
    private ClusteringAgent loadBalancerAgent;

    public ClusteringClient(RegistrantDatabase registrantDatabase) {
        this.registrantDatabase = registrantDatabase;
    }

    public void init(Properties conf, ConfigurationContext configurationContext, MembershipListener membershipListener) throws CartridgeAgentException {
        try {
            this.conf = conf;
            this.joinLoadBalancer(configurationContext, membershipListener);
        }
        catch (Exception e) {
            String msg = "Cannot initialize ClusteringClient";
            log.error((Object)msg, (Throwable)e);
            throw new CartridgeAgentException(msg, e);
        }
    }

    private void joinLoadBalancer(ConfigurationContext configurationContext, MembershipListener membershipListener) throws CartridgeAgentException {
        try {
            this.loadBalancerAgent = this.createClusteringAgent(configurationContext, this.conf.getProperty("loadBalancerDomain"));
            ArrayList<MembershipListener> membershipListeners = new ArrayList<MembershipListener>();
            membershipListeners.add(membershipListener);
            ((TribesClusteringAgent)this.loadBalancerAgent).setMembershipListeners(membershipListeners);
            this.loadBalancerAgent.init();
        }
        catch (Exception e) {
            String msg = "Cannot join LB group";
            log.error((Object)msg, (Throwable)e);
            throw new CartridgeAgentException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinGroup(Registrant registrant, ConfigurationContext configurationContext) throws CartridgeAgentException {
        ClusteringAgent agent;
        block19: {
            if (this.registrantDatabase.containsActive(registrant)) {
                throw new CartridgeAgentException("Active registrant with key " + registrant.getKey() + " already exists");
            }
            this.registrantDatabase.add(registrant);
            if (!RegistrantUtil.isHealthy(registrant)) {
                String msg = "Couldn't add registrant " + registrant + " due to a health check failure";
                log.error((Object)msg);
                return;
            }
            try {
                List clusteringCommands = this.loadBalancerAgent.sendMessage((ClusteringMessage)new CreateClusterDomainMessage(registrant.getService(), registrant.retrieveClusterDomain(), registrant.getHostName(), registrant.getTenantRange(), registrant.getMinInstanceCount(), registrant.getMaxInstanceCount(), registrant.getMaxRequestsPerSecond(), registrant.getRoundsToAverage(), registrant.getAlarmingUpperRate(), registrant.getAlarmingLowerRate(), registrant.getScaleDownFactor()), true);
                if (clusteringCommands != null && !clusteringCommands.isEmpty()) {
                    for (ClusteringCommand clusteringCommand : clusteringCommands) {
                        clusteringCommand.execute(configurationContext);
                    }
                    break block19;
                }
                return;
            }
            catch (ClusteringFault e) {
                this.handleException("Cannot send CreateClusterDomainMessage to ELB", (Exception)((Object)e));
            }
        }
        try {
            agent = this.createClusteringAgent(configurationContext, registrant.retrieveClusterDomain());
        }
        catch (ClusteringFault e) {
            this.handleException("Cannot create ClusteringAgent for registrant", (Exception)((Object)e));
            return;
        }
        Parameter propsParam = new Parameter();
        propsParam.setName("properties");
        StringBuilder propertiesPayload = new StringBuilder("<parameter name=\"properties\">");
        int httpPort = -1;
        int httpsPort = -1;
        for (PortMapping portMapping : registrant.getPortMappings()) {
            propertiesPayload.append("<property name=\"portMapping.mapping.").append(portMapping.getProxyPort()).append("\" value=\"").append(portMapping.getPrimaryPort()).append("\" />");
            if (portMapping.getType().equals("http")) {
                httpPort = portMapping.getPrimaryPort();
                continue;
            }
            if (!portMapping.getType().equals("https")) continue;
            httpsPort = portMapping.getPrimaryPort();
        }
        String remoteHost = registrant.getRemoteHost();
        propertiesPayload.append("<property name=\"httpPort\" value=\"").append(httpPort).append("\" />");
        propertiesPayload.append("<property name=\"httpsPort\" value=\"").append(httpsPort).append("\" />");
        propertiesPayload.append("<property name=\"remoteHost\" value=\"").append(remoteHost).append("\" />");
        propertiesPayload.append("<property name=\"subDomain\" value=\"__$default\" />");
        propertiesPayload.append("</parameter>");
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(propertiesPayload.toString().getBytes()));
            propsParam.setParameterElement(builder.getDocumentElement());
            agent.addParameter(propsParam);
        }
        catch (XMLStreamException e) {
            this.handleException("Cannot create properties ClusteringAgent parameter", e);
        }
        catch (AxisFault ignored) {
            // empty catch block
        }
        int newMemberPort = Integer.parseInt(this.conf.getProperty("clustering.localMemberPort")) + RANDOM.nextInt(5000) + 27;
        ClusteringClient.addParameter(agent, "localMemberPort", newMemberPort + "");
        try {
            Registrant i$ = registrant;
            synchronized (i$) {
                if (!registrant.running()) {
                    registrant.start(agent);
                }
            }
        }
        catch (ClusteringFault e) {
            this.handleException("Cannot start registrant", (Exception)((Object)e));
        }
        new Thread(new InstanceStateNotificationClientThread(registrant, "ACTIVE")).start();
    }

    public void removeClusterDomain(String domain, String subDomain, String hostName, ConfigurationContext configurationContext) throws CartridgeAgentException {
        block4: {
            try {
                List clusteringCommands = this.loadBalancerAgent.sendMessage((ClusteringMessage)new CreateRemoveClusterDomainMessage(domain, subDomain, hostName), true);
                if (clusteringCommands != null && !clusteringCommands.isEmpty()) {
                    for (ClusteringCommand clusteringCommand : clusteringCommands) {
                        clusteringCommand.execute(configurationContext);
                    }
                    break block4;
                }
                return;
            }
            catch (ClusteringFault e) {
                this.handleException("Cannot send CreateClusterDomainMessage to ELB", (Exception)((Object)e));
            }
        }
    }

    private void handleException(String msg, Exception e) throws CartridgeAgentException {
        log.error((Object)msg, (Throwable)e);
        throw new CartridgeAgentException(msg, e);
    }

    private ClusteringAgent createClusteringAgent(ConfigurationContext configurationContext, String clusterDomain) throws ClusteringFault {
        TribesClusteringAgent agent = new TribesClusteringAgent();
        ClusteringClient.addParameter((ClusteringAgent)agent, "AvoidInitiation", "true");
        for (String key : this.conf.stringPropertyNames()) {
            if (!key.startsWith("clustering.")) continue;
            ClusteringClient.addParameter((ClusteringAgent)agent, key.substring(key.indexOf(".") + 1), this.conf.getProperty(key));
        }
        ArrayList<Member> members = new ArrayList<Member>();
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String host = this.conf.getProperty("members." + i + ".host");
            String port = this.conf.getProperty("members." + i + ".port");
            if (host == null || port == null) break;
            members.add(new Member(host, Integer.parseInt(port)));
        }
        agent.setMembers(members);
        ClusteringClient.addParameter((ClusteringAgent)agent, "domain", clusterDomain);
        agent.setConfigurationContext(configurationContext);
        ArrayList<RegistrantMembershipListener> membershipListeners = new ArrayList<RegistrantMembershipListener>();
        membershipListeners.add(new RegistrantMembershipListener(this, configurationContext));
        agent.setMembershipListeners(membershipListeners);
        return agent;
    }

    private static void addParameter(ClusteringAgent agent, String paramName, String paramValue) {
        Parameter parameter = new Parameter(paramName, (Object)paramValue);
        try {
            agent.removeParameter(parameter);
            agent.addParameter(parameter);
        }
        catch (AxisFault ignored) {
            // empty catch block
        }
    }
}

