/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.registrant;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.stratos.cartridge.agent.registrant.PortMapping;

public class Registrant
implements Serializable {
    private static final long serialVersionUID = 1026289225178520964L;
    private String key;
    private String tenantRange;
    private String service;
    private String hostName;
    private PortMapping[] portMappings;
    private String remoteHost;
    private transient ClusteringAgent clusteringAgent;
    private int minInstanceCount;
    private int maxInstanceCount;
    private int maxRequestsPerSecond;
    private int roundsToAverage;
    private double alarmingUpperRate;
    private double alarmingLowerRate;
    private double scaleDownFactor;

    public String getService() {
        return this.service;
    }

    public String getTenantRange() {
        return this.tenantRange;
    }

    public void setTenantRange(String tenantRange) {
        this.tenantRange = tenantRange;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public PortMapping[] getPortMappings() {
        return Arrays.copyOf(this.portMappings, this.portMappings.length);
    }

    public void setPortMappings(PortMapping[] portMappings) {
        this.portMappings = Arrays.copyOf(portMappings, portMappings.length);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getMinInstanceCount() {
        return this.minInstanceCount;
    }

    public void setMinInstanceCount(int minInstanceCount) {
        this.minInstanceCount = minInstanceCount;
    }

    public int getMaxInstanceCount() {
        return this.maxInstanceCount;
    }

    public void setMaxInstanceCount(int maxInstanceCount) {
        this.maxInstanceCount = maxInstanceCount;
    }

    public String retrieveClusterDomain() {
        return this.hostName + "." + this.service + ".domain";
    }

    public void start(ClusteringAgent clusteringAgent) throws ClusteringFault {
        this.clusteringAgent = clusteringAgent;
        clusteringAgent.init();
    }

    public void stop() {
        if (this.clusteringAgent != null) {
            this.clusteringAgent.stop();
        }
        this.clusteringAgent = null;
    }

    public boolean running() {
        return this.clusteringAgent != null;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getMaxRequestsPerSecond() {
        return this.maxRequestsPerSecond;
    }

    public void setMaxRequestsPerSecond(int maxRequestsPerSecond) {
        this.maxRequestsPerSecond = maxRequestsPerSecond;
    }

    public int getRoundsToAverage() {
        return this.roundsToAverage;
    }

    public void setRoundsToAverage(int roundsToAverage) {
        this.roundsToAverage = roundsToAverage;
    }

    public double getAlarmingUpperRate() {
        return this.alarmingUpperRate;
    }

    public void setAlarmingUpperRate(double alarmingUpperRate) {
        this.alarmingUpperRate = alarmingUpperRate;
    }

    public double getAlarmingLowerRate() {
        return this.alarmingLowerRate;
    }

    public void setAlarmingLowerRate(double alarmingLowerRate) {
        this.alarmingLowerRate = alarmingLowerRate;
    }

    public double getScaleDownFactor() {
        return this.scaleDownFactor;
    }

    public void setScaleDownFactor(double scaleDownFactor) {
        this.scaleDownFactor = scaleDownFactor;
    }

    public String toString() {
        return "Registrant{key='" + this.key + '\'' + ", remoteHost='" + this.remoteHost + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registrant that = (Registrant)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

