/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.RepositoryFileListener;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.RepositoryInformation;
import org.apache.stratos.cartridge.agent.artifact.deployment.synchronizer.git.impl.GitBasedArtifactRepository;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.data.publisher.DataPublisherConfiguration;
import org.apache.stratos.cartridge.agent.data.publisher.exception.DataPublisherException;
import org.apache.stratos.cartridge.agent.data.publisher.log.LogPublisherManager;
import org.apache.stratos.cartridge.agent.event.publisher.CartridgeAgentEventPublisher;
import org.apache.stratos.cartridge.agent.util.CartridgeAgentUtils;
import org.apache.stratos.cartridge.agent.util.ExtensionUtils;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.instance.notifier.ArtifactUpdatedEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupClusterEvent;
import org.apache.stratos.messaging.event.instance.notifier.InstanceCleanupMemberEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.instance.notifier.ArtifactUpdateEventListener;
import org.apache.stratos.messaging.listener.instance.notifier.InstanceCleanupClusterEventListener;
import org.apache.stratos.messaging.listener.instance.notifier.InstanceCleanupMemberEventListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventReceiver;

public class CartridgeAgent
implements Runnable {
    private static final Log log = LogFactory.getLog(CartridgeAgent.class);
    private boolean terminated;

    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Cartridge agent started");
        }
        this.validateRequiredSystemProperties();
        this.subscribeToTopicsAndRegisterListeners();
        CartridgeAgentEventPublisher.publishInstanceStartedEvent();
        ExtensionUtils.executeStartServersExtension();
        CartridgeAgentUtils.waitUntilPortsActive(CartridgeAgentConfiguration.getInstance().getListenAddress(), CartridgeAgentConfiguration.getInstance().getPorts());
        String repoUrl = CartridgeAgentConfiguration.getInstance().getRepoUrl();
        if ("null".equals(repoUrl) || StringUtils.isBlank((CharSequence)repoUrl)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"No artifact repository found");
            }
            CartridgeAgentEventPublisher.publishInstanceActivatedEvent();
        } else if (CartridgeAgentConfiguration.getInstance().isCommitsEnabled()) {
            log.info((Object)" Commits enabled. Starting File listener ");
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            scheduler.scheduleWithFixedDelay(new RepositoryFileListener(), 0L, 10L, TimeUnit.SECONDS);
        }
        String persistanceMappingsPayload = CartridgeAgentConfiguration.getInstance().getPersistenceMappings();
        if (persistanceMappingsPayload != null) {
            ExtensionUtils.executeVolumeMountExtension(persistanceMappingsPayload);
        }
        LogPublisherManager logPublisherManager = new LogPublisherManager();
        CartridgeAgent.publishLogs(logPublisherManager);
        while (!this.terminated) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        logPublisherManager.stop();
    }

    protected void subscribeToTopicsAndRegisterListeners() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting instance notifier event message receiver thread");
        }
        InstanceNotifierEventReceiver eventReceiver = new InstanceNotifierEventReceiver();
        eventReceiver.addEventListener((EventListener)new ArtifactUpdateEventListener(){

            protected void onEvent(Event event) {
                CartridgeAgent.this.onArtifactUpdateEvent((ArtifactUpdatedEvent)event);
            }
        });
        eventReceiver.addEventListener((EventListener)new InstanceCleanupMemberEventListener(){

            protected void onEvent(Event event) {
                InstanceCleanupMemberEvent instanceCleanupMemberEvent;
                String memberIdInPayload = CartridgeAgentConfiguration.getInstance().getMemberId();
                if (memberIdInPayload.equals((instanceCleanupMemberEvent = (InstanceCleanupMemberEvent)event).getMemberId())) {
                    CartridgeAgent.this.onInstanceCleanupEvent();
                }
            }
        });
        eventReceiver.addEventListener((EventListener)new InstanceCleanupClusterEventListener(){

            protected void onEvent(Event event) {
                InstanceCleanupClusterEvent instanceCleanupClusterEvent;
                String clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId();
                if (clusterIdInPayload.equals((instanceCleanupClusterEvent = (InstanceCleanupClusterEvent)event).getClusterId())) {
                    CartridgeAgent.this.onInstanceCleanupEvent();
                }
            }
        });
        Thread eventReceiverThread = new Thread((Runnable)eventReceiver);
        eventReceiverThread.start();
        while (!eventReceiver.isSubscribed()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void validateRequiredSystemProperties() {
        String jndiPropertiesDir = System.getProperty("jndi.properties.dir");
        if (StringUtils.isBlank((CharSequence)jndiPropertiesDir)) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("System property not found: %s", "jndi.properties.dir"));
            }
            return;
        }
        String payloadPath = System.getProperty("param.file.path");
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("System property not found: %s", "param.file.path"));
            }
            return;
        }
        String extensionsDir = System.getProperty("extensions.dir");
        if (StringUtils.isBlank((CharSequence)extensionsDir) && log.isWarnEnabled()) {
            log.warn((Object)String.format("System property not found: %s", "extensions.dir"));
        }
    }

    private static void publishLogs(LogPublisherManager logPublisherManager) {
        if (DataPublisherConfiguration.getInstance().isEnabled()) {
            List<String> logFilePaths = CartridgeAgentConfiguration.getInstance().getLogFilePaths();
            if (logFilePaths == null) {
                log.error((Object)"No valid log file paths found, no logs will be published");
                return;
            }
            try {
                logPublisherManager.init(DataPublisherConfiguration.getInstance());
            }
            catch (DataPublisherException e) {
                log.error((Object)"Error occurred in log publisher initialization", (Throwable)e);
                return;
            }
            for (String logFilePath : logFilePaths) {
                try {
                    logPublisherManager.start(logFilePath);
                }
                catch (DataPublisherException e) {
                    log.error((Object)"Error occurred in publishing logs ", (Throwable)e);
                }
            }
        }
    }

    private void onArtifactUpdateEvent(ArtifactUpdatedEvent event) {
        ArtifactUpdatedEvent artifactUpdatedEvent = event;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Artifact update event received: %s", artifactUpdatedEvent.toString()));
        }
        String clusterIdInPayload = CartridgeAgentConfiguration.getInstance().getClusterId();
        String localRepoPath = CartridgeAgentConfiguration.getInstance().getAppPath();
        String clusterIdInMessage = artifactUpdatedEvent.getClusterId();
        String repoURL = artifactUpdatedEvent.getRepoURL();
        String repoPassword = CartridgeAgentUtils.decryptPassword(artifactUpdatedEvent.getRepoPassword());
        String repoUsername = artifactUpdatedEvent.getRepoUserName();
        String tenantId = artifactUpdatedEvent.getTenantId();
        boolean isMultitenant = CartridgeAgentConfiguration.getInstance().isMultitenant();
        if (StringUtils.isNotEmpty((CharSequence)repoURL) && clusterIdInPayload != null && clusterIdInPayload.equals(clusterIdInMessage)) {
            boolean artifactUpdateEnabled;
            if (log.isInfoEnabled()) {
                log.info((Object)"Executing git checkout");
            }
            RepositoryInformation repoInformation = new RepositoryInformation();
            repoInformation.setRepoUsername(repoUsername);
            if (repoPassword == null) {
                repoInformation.setRepoPassword("");
            } else {
                repoInformation.setRepoPassword(repoPassword);
            }
            repoInformation.setRepoUrl(repoURL);
            repoInformation.setRepoPath(localRepoPath);
            repoInformation.setTenantId(tenantId);
            repoInformation.setMultitenant(isMultitenant);
            boolean cloneExists = GitBasedArtifactRepository.getInstance().cloneExists(repoInformation);
            GitBasedArtifactRepository.getInstance().checkout(repoInformation);
            ExtensionUtils.executeArtifactsUpdatedExtension();
            if (!cloneExists) {
                CartridgeAgentEventPublisher.publishInstanceActivatedEvent();
            }
            if (artifactUpdateEnabled = Boolean.parseBoolean(System.getProperty("enable.artifact.update"))) {
                long artifactUpdateInterval = 10L;
                String artifactUpdateIntervalStr = System.getProperty("artifact.update.interval");
                if (artifactUpdateIntervalStr != null && !artifactUpdateIntervalStr.isEmpty()) {
                    try {
                        artifactUpdateInterval = Long.parseLong(artifactUpdateIntervalStr);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Invalid artifact sync interval specified ", (Throwable)e);
                        artifactUpdateInterval = 10L;
                    }
                }
                log.info((Object)("Artifact updating task enabled, update interval: " + artifactUpdateInterval + "s"));
                GitBasedArtifactRepository.getInstance().scheduleSyncTask(repoInformation, artifactUpdateInterval);
            } else {
                log.info((Object)"Artifact updating task disabled");
            }
        }
    }

    private void onInstanceCleanupEvent() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Executing cleaning up the data in the cartridge instance...");
        }
        CartridgeAgentEventPublisher.publishMaintenanceModeEvent();
        ExtensionUtils.executeCleanupExtension();
        if (log.isInfoEnabled()) {
            log.info((Object)"cleaning up finished in the cartridge instance...");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"publishing ready to shutdown event...");
        }
        CartridgeAgentEventPublisher.publishInstanceReadyToShutdownEvent();
    }

    public void terminate() {
        this.terminated = true;
    }
}

