/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.config.configurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiConfigurator {
    private static final Log log = LogFactory.getLog(JndiConfigurator.class);

    public static void configure() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring jndi.properties file");
        }
        JndiConfigurator.generateJndiPropertiesFile();
    }

    private static void generateJndiPropertiesFile() {
        String mbIp = System.getProperty("mb.ip");
        if (StringUtils.isBlank((CharSequence)mbIp)) {
            throw new RuntimeException("System property not found: mb.ip");
        }
        String mbPort = System.getProperty("mb.port");
        if (StringUtils.isBlank((CharSequence)mbPort)) {
            throw new RuntimeException("System property not found: mb.port");
        }
        String templateFilePath = System.getProperty("jndi.properties.template.file.path");
        if (StringUtils.isBlank((CharSequence)templateFilePath)) {
            throw new RuntimeException("System property not found: jndi.properties.template.file.path");
        }
        String jndiFileDir = System.getProperty("jndi.properties.dir");
        if (StringUtils.isBlank((CharSequence)jndiFileDir)) {
            throw new RuntimeException("System property not found: jndi.properties.dir");
        }
        String jndiFilePath = null;
        jndiFilePath = jndiFileDir.endsWith("/") ? jndiFileDir + "jndi.properties" : jndiFileDir + "/" + "jndi.properties";
        File templateFile = new File(templateFilePath);
        if (!templateFile.exists()) {
            throw new RuntimeException(String.format("File not found: %s", templateFilePath));
        }
        try {
            String content = JndiConfigurator.readFileContent(templateFilePath);
            content = content.replace("$mb_ip", mbIp);
            content = content.replace("$mb_port", mbPort);
            JndiConfigurator.writeFileContent(content, jndiFilePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("jndi.properties file written to: %s", jndiFilePath));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write jndi.properties file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContent(String templateFilePath) throws IOException {
        FileInputStream inputStream = new FileInputStream(templateFilePath);
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private static void writeFileContent(String content, String filePath) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(filePath);
        IOUtils.write((String)content, (OutputStream)outputStream);
    }
}

