/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cartridge.agent.config.CartridgeAgentConfiguration;
import org.apache.stratos.cartridge.agent.statistics.publisher.HealthStatisticsPublisher;
import org.apache.stratos.cartridge.agent.statistics.publisher.HealthStatisticsReader;

public class HealthStatisticsNotifier
implements Runnable {
    private static final Log log = LogFactory.getLog(HealthStatisticsNotifier.class);
    private final HealthStatisticsPublisher statsPublisher = new HealthStatisticsPublisher();
    private long statsPublisherInterval = 15000L;
    private boolean terminated;

    public HealthStatisticsNotifier() {
        String interval = System.getProperty("stats.notifier.interval");
        if (interval != null) {
            this.statsPublisherInterval = Long.getLong(interval);
        }
    }

    @Override
    public void run() {
        while (!this.terminated) {
            try {
                try {
                    Thread.sleep(this.statsPublisherInterval);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (this.statsPublisher.isEnabled()) {
                    double memoryConsumption = HealthStatisticsReader.getMemoryConsumption();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Publishing memory consumption: %f", memoryConsumption));
                    }
                    this.statsPublisher.publish(CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getPartitionId(), "memory_consumption", memoryConsumption);
                    double loadAverage = HealthStatisticsReader.getLoadAverage();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Publishing load average: %f", loadAverage));
                    }
                    this.statsPublisher.publish(CartridgeAgentConfiguration.getInstance().getClusterId(), CartridgeAgentConfiguration.getInstance().getNetworkPartitionId(), CartridgeAgentConfiguration.getInstance().getMemberId(), CartridgeAgentConfiguration.getInstance().getPartitionId(), "load_average", loadAverage);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Statistics publisher is disabled");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Could not publish health statistics", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

