/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.statistics.publisher;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.WSO2CEPStatisticsPublisher;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class HealthStatisticsPublisher
extends WSO2CEPStatisticsPublisher {
    private static final Log log = LogFactory.getLog(HealthStatisticsPublisher.class);
    private static final String DATA_STREAM_NAME = "cartridge_agent_health_stats";
    private static final String VERSION = "1.0.0";

    private static StreamDefinition createStreamDefinition() {
        try {
            StreamDefinition streamDefinition = new StreamDefinition(DATA_STREAM_NAME, VERSION);
            streamDefinition.setNickName("agent health stats");
            streamDefinition.setDescription("agent health stats");
            ArrayList<Attribute> payloadData = new ArrayList<Attribute>();
            payloadData.add(new Attribute("cluster_id", AttributeType.STRING));
            payloadData.add(new Attribute("network_partition_id", AttributeType.STRING));
            payloadData.add(new Attribute("member_id", AttributeType.STRING));
            payloadData.add(new Attribute("partition_id", AttributeType.STRING));
            payloadData.add(new Attribute("health_description", AttributeType.STRING));
            payloadData.add(new Attribute("value", AttributeType.DOUBLE));
            streamDefinition.setPayloadData(payloadData);
            return streamDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create stream definition", e);
        }
    }

    public HealthStatisticsPublisher() {
        super(HealthStatisticsPublisher.createStreamDefinition());
    }

    public void publish(String clusterId, String networkPartitionId, String memberId, String partitionId, String health, double value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Publishing health statistics: [cluster] %s [network-partition] %s [partition] %s [member] %s [health] %s [value] %f", clusterId, networkPartitionId, partitionId, memberId, health, value));
        }
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(clusterId);
        payload.add(networkPartitionId);
        payload.add(memberId);
        payload.add(partitionId);
        payload.add(health);
        payload.add(value);
        super.publish(payload.toArray());
    }
}

