/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.cartridge.agent.util;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommandUtils;

public class ExtensionUtils {
    private static final Log log = LogFactory.getLog(ExtensionUtils.class);

    private static String getExtensionsDir() {
        String extensionsDir = System.getProperty("extensions.dir");
        if (StringUtils.isBlank((CharSequence)extensionsDir)) {
            throw new RuntimeException(String.format("System property not found: %s", "extensions.dir"));
        }
        return extensionsDir;
    }

    private static String prepareCommand(String scriptFile) {
        String extensionsDir = ExtensionUtils.getExtensionsDir();
        return extensionsDir.endsWith(File.separator) ? extensionsDir + scriptFile : extensionsDir + File.separator + scriptFile;
    }

    public static void executeStartServersExtension() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing start servers extension");
            }
            String command = ExtensionUtils.prepareCommand("start-servers.sh");
            CommandUtils.executeCommand((String)command);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute start servers extension", (Throwable)e);
        }
    }

    public static void executeCleanupExtension() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing start servers extension");
            }
            String command = ExtensionUtils.prepareCommand("clean.sh");
            CommandUtils.executeCommand((String)command);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute start servers extension", (Throwable)e);
        }
    }

    public static void executeInstanceStartedExtension() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing instance started extension");
            }
            String command = ExtensionUtils.prepareCommand("instance-started.sh");
            CommandUtils.executeCommand((String)command);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute instance started extension", (Throwable)e);
        }
    }

    public static void executeInstanceActivatedExtension() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing instance activated extension");
            }
            String command = ExtensionUtils.prepareCommand("instance-activated.sh");
            CommandUtils.executeCommand((String)command);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute instance activated extension", (Throwable)e);
        }
    }

    public static void executeArtifactsUpdatedExtension() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing artifacts updated extension");
            }
            String command = ExtensionUtils.prepareCommand("artifacts-updated.sh");
            CommandUtils.executeCommand((String)command);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute artifacts updated extension", (Throwable)e);
        }
    }

    public static void executeVolumeMountExtension(String persistanceMappingsPayload) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Executing volume mounting extension");
            }
            String command = ExtensionUtils.prepareCommand("mount_volumes.sh");
            CommandUtils.executeCommand((String)(command + " " + persistanceMappingsPayload));
        }
        catch (Exception e) {
            log.error((Object)"Could not execute volume mounting extension", (Throwable)e);
        }
    }
}

