/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.packages;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.exception.StratosException;
import org.apache.stratos.common.packages.PackageInfo;
import org.apache.stratos.common.util.CommonUtil;
import org.jaxen.JaxenException;
import org.wso2.carbon.utils.CarbonUtils;

public class PackageInfoHolder {
    private static Log log = LogFactory.getLog(PackageInfoHolder.class);
    private static final String PACKAGE_DESCRIPTION_CONFIG = "multitenancy-packages.xml";
    private static final String PACKAGE_DESCRIPTION_CONFIG_NS = "http://wso2.com/carbon/multitenancy/billing/pacakges";
    List<PackageInfo> multitenancyPackages = this.deserializePackageDescriptionConfig();

    public List<PackageInfo> getMultitenancyPackages() {
        return this.multitenancyPackages;
    }

    private List<PackageInfo> deserializePackageDescriptionConfig() throws StratosException {
        OMElement packageConfigs;
        String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + PACKAGE_DESCRIPTION_CONFIG;
        try {
            packageConfigs = CommonUtil.buildOMElement(new FileInputStream(configFilePath));
        }
        catch (Exception e) {
            String msg = "Error in deserializing the packageConfigs file: " + configFilePath + ".";
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, e);
        }
        Iterator packageConfigsChildsIt = packageConfigs.getChildElements();
        while (packageConfigsChildsIt.hasNext()) {
            OMElement packageConfigEle = (OMElement)packageConfigsChildsIt.next();
            if (!new QName(PACKAGE_DESCRIPTION_CONFIG_NS, "package").equals(packageConfigEle.getQName())) continue;
            PackageInfo multitenancyPackage = new PackageInfo();
            String packageName = packageConfigEle.getAttributeValue(new QName("name"));
            String subscriptionCharge = this.getPackageConfigValue("subscriptionCharge", packageConfigEle);
            String usersLimit = this.getPackageConfigValue("users.limit", packageConfigEle);
            String usersCharge = this.getPackageConfigValue("users.charge", packageConfigEle);
            String resourceVolumeLimit = this.getPackageConfigValue("resourceVolume.limit", packageConfigEle);
            String resourceVolumeOveruseCharge = this.getPackageConfigValue("resourceVolume.overuseCharge", packageConfigEle);
            String bandwidthLimit = this.getPackageConfigValue("bandwidth.limit", packageConfigEle);
            String bandwidthOveruseCharge = this.getPackageConfigValue("bandwidth.overuseCharge", packageConfigEle);
            int usersLimitInt = -1;
            if (!usersLimit.equals("unlimited")) {
                usersLimitInt = Integer.parseInt(usersLimit);
            }
            int resourceVolumeLimitInt = -1;
            if (!resourceVolumeLimit.equals("unlimited")) {
                resourceVolumeLimitInt = Integer.parseInt(resourceVolumeLimit);
            }
            int bandwidthLimitInt = -1;
            if (!bandwidthLimit.equals("unlimited")) {
                bandwidthLimitInt = Integer.parseInt(bandwidthLimit);
            }
            multitenancyPackage.setName(packageName);
            multitenancyPackage.setSubscriptionCharge(Integer.parseInt(subscriptionCharge));
            multitenancyPackage.setUsersLimit(usersLimitInt);
            multitenancyPackage.setResourceVolumeLimit(resourceVolumeLimitInt);
            multitenancyPackage.setBandwidthLimit(bandwidthLimitInt);
            this.multitenancyPackages.add(multitenancyPackage);
        }
        return this.multitenancyPackages;
    }

    private String getPackageConfigValue(String key, OMElement packageNode) throws StratosException {
        String qualifiedKey = "ns:" + key.replaceAll("\\.", "/ns:");
        try {
            AXIOMXPath xpathExpression = new AXIOMXPath(qualifiedKey);
            xpathExpression.addNamespace("ns", PACKAGE_DESCRIPTION_CONFIG_NS);
            List valueNodes = xpathExpression.selectNodes((Object)packageNode);
            if (valueNodes.isEmpty()) {
                if (log.isDebugEnabled()) {
                    String msg = "No results found parsing package configuration for key: " + qualifiedKey + ".";
                    log.debug((Object)msg);
                }
                return null;
            }
            OMElement valueNode = (OMElement)valueNodes.get(0);
            return valueNode.getText();
        }
        catch (JaxenException e) {
            String msg = "Error in retrieving the key: " + qualifiedKey + ".";
            log.error((Object)msg, (Throwable)e);
            throw new StratosException(msg, e);
        }
    }
}

