/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.lb.common.cache;

import java.util.Map;
import org.apache.stratos.lb.common.cache.LRUCache;
import org.apache.stratos.lb.common.util.DomainMapping;

public class URLMappingCache {
    private Map<String, DomainMapping> validMappings;
    private static URLMappingCache instance = null;

    protected URLMappingCache(int maxValidKeys) {
        this.validMappings = new LRUCache<String, DomainMapping>(maxValidKeys);
    }

    public void addValidMapping(String hostName, DomainMapping mapping) {
        this.validMappings.put(hostName, mapping);
    }

    public DomainMapping getMapping(String hostName) {
        return this.validMappings.get(hostName);
    }

    public static URLMappingCache getInstance(int maxValidKeys) {
        if (instance == null) {
            instance = new URLMappingCache(maxValidKeys);
        }
        return instance;
    }
}

